/* rotate.m,
 *
 * Some useful rotation routines.
 */

#include <math.h>
#include "rotate.h"


/* Rotate point x,y by angle theta and return via rx,ry, given
 * cos(theta) and sin(theta).
 */
inline void rotate2(const double x, const double y,
		    const double cos_theta, const double sin_theta,
		    double* const rx, double* const ry)
{
    *rx = x*cos_theta - y*sin_theta;
    *ry = x*sin_theta + y*cos_theta;
}


/* Rotate point x,y by angle theta and return via rx,ry.
 */
inline void rotate(const double x, const double y, const double theta,
		   double* const rx, double* const ry)
{
#if 0
    double cos_theta = cos(theta);
    double sin_theta = sin(theta);

    *rx = x*cos_theta - y*sin_theta;
    *ry = x*sin_theta + y*cos_theta;
#else
    rotate2(x, y, cos(theta), sin(theta), rx, ry);
#endif
}


/* Rotate towards theta_desired, but at most theta_max (radians),
 * taking into account that +pi == -pi.  Returns YES if we reach the
 * desired angle.
 */
BOOL limited_rotate(double* const theta, const double theta_desired, const double theta_max)
{
    /* We are within one step of the desired angle. */
    if (fabs(*theta - theta_desired) < theta_max) {
        *theta = theta_desired;
	return YES;
    }

    /* Make sure things don't rotate stupidly when passing +-PI. */
    else if (*theta > theta_desired + M_PI) *theta += theta_max;
    else if (*theta < theta_desired - M_PI) *theta -= theta_max;

    /* Normal rotation. */
    else if (*theta < theta_desired) *theta += theta_max;
    else if (*theta > theta_desired) *theta -= theta_max;

    return NO;
}
