/* vulcan.m,
 *
 * Vulcan projectiles are the standard weapon of the player's ship.
 * The red weapon in all top-down shooters, including this one.
 */

#include <allegro.h>
#include <math.h>
#include "candy/line-spark.h"
#include "collision.inc"
#include "common.h"
#include "projectiles/vulcan.h"
#include "seborrhea/seborrhea.h"
#include "sound.h"


#define LEVEL0_DAMAGE	20	/* x2 shots. */
#define LEVEL1_DAMAGE	18	/* x3 shots. */
#define LEVEL2_DAMAGE	16	/* x4 shots. */

static Sebum<SebSample> *fire_sample;

/*--------------------------------------------------------------*/

@interface VulcanMedium: Vulcan
@end

@interface VulcanHigh: Vulcan
@end

/*--------------------------------------------------------------*/

@implementation Vulcan
+ initialize
{
    fire_sample = [base_sebum getSebumByName:"weapon/vulcan-snd"];
    return self;
}

- init
{
    [super init];

    health = LEVEL0_DAMAGE;

    sprite = [base_sebum getSebumByName:"weapon/vulcan"];
    w = 8;	//[sprite width];
    h = 14;	//[sprite height];

    angle = M_PI_2;
    speed = 8.0;

    return self;
}

- (void) die
{
    int i;

    /* Some extra sparks. */
    for (i = 0; i < 2*candy_amount; i++)
	[spawn_candy([LineSpark class], x, y, HIGH_LAYER)
		    setAngle:deg2rad(rnd(-180, 0))];
    [super die];
}

+ (enum DAMAGE_TYPE) damageType
{
    return DAMAGE_TYPE_VULCAN;
}
@end


@implementation VulcanMedium
- init
{
    [super init];
    health = LEVEL1_DAMAGE;
    return self;
}
@end


@implementation VulcanHigh
- init
{
    [super init];
    health = LEVEL2_DAMAGE;
    return self;
}
@end

/*------------------------------------------------------------*/

void fireVulcan(double x, double y, primary_weapon_t *w, const int pid)
{
#define SPAWN_ALLY_PROJ(p,x,y)		[(AllyProjectile *)spawn_projectile([p class],x,y,YES) setParentID:pid]

    y -= 10;
    if (w->level == 0) {
        SPAWN_ALLY_PROJ(Vulcan, x-5, y);
	SPAWN_ALLY_PROJ(Vulcan, x+5, y);
    }
    elif (w->level == 1) {
	SPAWN_ALLY_PROJ(VulcanMedium, x, y);
	[SPAWN_ALLY_PROJ(VulcanMedium, x-10, y) setAngle:deg2rad(95.0)];
	[SPAWN_ALLY_PROJ(VulcanMedium, x+10, y) setAngle:deg2rad(85.0)];
    }
    else {
	[SPAWN_ALLY_PROJ(VulcanHigh, x-12, y) setAngle:deg2rad(96.0)];
	[SPAWN_ALLY_PROJ(VulcanHigh, x- 5, y) setAngle:deg2rad(92.0)];
	[SPAWN_ALLY_PROJ(VulcanHigh, x+ 5, y) setAngle:deg2rad(88.0)];
	[SPAWN_ALLY_PROJ(VulcanHigh, x+12, y) setAngle:deg2rad(84.0)];
    }

    w->tics = 10;

    play_voice_on_channels(fire_sample, x, 192, PRIMARY_WEAPON_CHANNELS);

#undef SPAWN_ALLY_PROJ
}
