/* rocket.m,
 *
 * Enemy missiles.  Slightly slower than player missiles.
 */

#include "candy/smoke.h"
#include "common.h"
#include "projectiles/rocket.h"
#include "seborrhea/seborrhea.h"


static SebFile *proj_data;


@implementation Rocket
+ derive_registerProjectile();
+ derive_loadDataProjectile(proj_data, "data/proj-rocket");
+ derive_shutdownProjectile(proj_data);

- init
{
    [super init];

    speed = 5.0;

    sprite = [proj_data getSebumByName:"rocket"];
    w = 13;	//[sprite width]-6;
    h = 6;	//[sprite height];
    rotated_sprite = YES;

    return self;
}

- (enum THING_UPDATE_STATE) update
{
    if (--smoke_tics <= 0) {
	spawn_candy([Smoke class], x, y, MEDIUM_LAYER);
	smoke_tics = 3;
    }
    return [super update];
}
@end
