/* pulse-laser.m,
 *
 * Rotatable enemy lasers.  Small, fast, and green.
 */

#include "common.h"
#include "projectiles/pulse-laser.h"
#include "seborrhea/seborrhea.h"


static SebFile *proj_data;


@implementation PulseLaser
+ derive_registerProjectile();
+ derive_loadDataProjectile(proj_data, "data/proj-pulselaser");
+ derive_shutdownProjectile(proj_data);

- init
{
    [super init];

    speed = 9.0;

    sprite = [proj_data getSebumByName:"laser"];
    w = 15;			/* Slightly smaller */
    h = [sprite height] - 2;
    rotated_sprite = YES;

    return self;
}
@end
