/* plasma.m,
 *
 * Enemy blobs of plasma.  Orange/yellow.
 */

#include "common.h"
#include "projectiles/plasma.h"
#include "seborrhea/seborrhea.h"


static SebFile *proj_data;
static SebAnimation *plasma_anim;


@implementation Plasma
+ derive_registerProjectile();

+ (BOOL) loadData
{
    if (not [self loadData:&proj_data :"data/proj-plasma"])
	return NO;

    plasma_anim = (SebAnimation *)[proj_data getSebumByName:"plasma"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(proj_data);
    plasma_anim = nil;
}

- init
{
    [super init];

    speed = rnd_with_rng(30, 35) / 10.0;

    sprite = [[SebAnimator new] setAnimation:plasma_anim];
    w = 13;	//[sprite width];
    h = 13;	//[sprite height];

    return self;
}
@end
