/* pink.m,
 *
 * "It's Pink!"
 */

#include <math.h>
#include "common.h"
#include "projectiles/pink.h"
#include "seborrhea/seborrhea.h"


#define LEVEL0_DAMAGE	25


static SebAnimation *pink_animation, *left_animation;


@implementation PinkOrangeRed
+ initialize
{
    pink_animation = (SebAnimation *)[base_sebum getSebumByName:"weapon/pink"];
    left_animation = (SebAnimation *)[base_sebum getSebumByName:"weapon/pink-l"];
    return self;
}

- init
{
    [super init];

    health = LEVEL0_DAMAGE;
    speed = 4.2;

    sprite = [[SebAnimator new] setAnimation:pink_animation];
    w = 18;	//[sprite width];
    h = 11;	//[sprite height]+4;

    return self;
}

- setAngle:(double)theta
{
    if ((theta > M_PI_2) || (theta < -M_PI_2))
	[(SebAnimator *)sprite setAnimation:left_animation];
    else
	[(SebAnimator *)sprite setAnimation:pink_animation];

    return [super setAngle:theta];
}
@end

/*------------------------------------------------------------*/

void firePinkOrangeRed(double x, double y, secondary_weapon_t *w, const int pid)
{
#define SPAWN_ALLY_PROJ(class,x,y,theta)		[[(AllyProjectile *)spawn_projectile(class,x,y,YES) setAngle:theta] setParentID:pid]

    Class proj = [PinkOrangeRed class];

    if (w->barrel == 0) {
        SPAWN_ALLY_PROJ(proj, x-13, y+5, deg2rad(170.0));
	SPAWN_ALLY_PROJ(proj, x+13, y+5, deg2rad(10.0));
    }
    elif (w->barrel == 2) {
	SPAWN_ALLY_PROJ(proj, x- 9, y+1, deg2rad(140.0));
	SPAWN_ALLY_PROJ(proj, x+ 9, y+1, deg2rad(40.0));
    }
    else {
	SPAWN_ALLY_PROJ(proj, x-11, y+3, deg2rad(155.0));
	SPAWN_ALLY_PROJ(proj, x+11, y+3, deg2rad(25.0));
    }

    (w->barrel)++;
    if ((w->level == 0) ||
	(w->level == 1 && w->barrel > 1) ||
	(w->level == 2 && w->barrel > 3)) {
	w->barrel = 0;
    }

    w->tics = 16 - 3*w->level;

#undef SPAWN_ALLY_PROJ
}
