/* missile.m,
 *
 * Missiles are ally secondary weapon projectiles.
 */

#include <math.h>
#include "candy/smoke.h"
#include "common.h"
#include "projectiles/missile.h"
#include "seborrhea/seborrhea.h"


#define LEVEL0_DAMAGE	50
#define LEVEL1_DAMAGE	45
#define LEVEL2_DAMAGE	40
#define SMOKE_DELAY	2

/*--------------------------------------------------------------*/

@interface MissileMedium: Missile
@end

@interface MissileHigh: Missile
@end

/*--------------------------------------------------------------*/

@implementation Missile
- init
{
    [super init];

    health = LEVEL0_DAMAGE;
    speed = 6.0;
    angle = -M_PI_2;

    sprite = [base_sebum getSebumByName:"weapon/missile"];
    w = 21;	//[sprite width];
    h = 9;	//[sprite height];
    rotated_sprite = YES;

    return self;
}

- (enum THING_UPDATE_STATE) update
{
    if (smoke_tics-- <= 0) {
	spawn_candy([Smoke class], x, y, MEDIUM_LAYER);
	smoke_tics = SMOKE_DELAY;
    }
    return [super update];
}
@end


@implementation MissileMedium
- init
{
    [super init];
    health = LEVEL1_DAMAGE;
    return self;
}
@end


@implementation MissileHigh
- init
{
    [super init];
    health = LEVEL2_DAMAGE;
    return self;
}
@end

/*------------------------------------------------------------*/

void fireMissile(double x, double y, secondary_weapon_t *w, const int pid)
{
#define SPAWN_ALLY_PROJ(p,x,y,theta)	[[(AllyProjectile *)spawn_projectile([p class],x,y,YES) setAngle:theta] setParentID:pid]

    y -= 10;
    if (w->level == 0) {
        SPAWN_ALLY_PROJ(Missile, x-10, y, deg2rad(100.0));
        SPAWN_ALLY_PROJ(Missile, x+10, y, deg2rad(80.0));
    } 
    elif (w->level == 1) {
        SPAWN_ALLY_PROJ(MissileMedium, x-10, y, deg2rad(110.0));
	SPAWN_ALLY_PROJ(MissileMedium, x   , y, deg2rad(90.0));
	SPAWN_ALLY_PROJ(MissileMedium, x+10, y, deg2rad(70.0));
    }
    else {
        SPAWN_ALLY_PROJ(MissileHigh, x-10, y, deg2rad(120.0));
        SPAWN_ALLY_PROJ(MissileHigh, x- 3, y, deg2rad(100.0));
        SPAWN_ALLY_PROJ(MissileHigh, x+ 3, y, deg2rad(80.0));
        SPAWN_ALLY_PROJ(MissileHigh, x+10, y, deg2rad(60.0));
    }

    w->tics = 50;

#undef SPAWN_ALLY_PROJ
}
