/* lightning-gun.m,
 *
 * Lightning gun thing for Khan.  Almost instant, but targets a point
 * in space instead of going off to infinity any beyond.
 */

#include <assert.h>
#include <math.h>
#include "map.h"
#include "projectiles/lightning-gun.h"


@implementation LightningGun
- init
{
    [super init];
    health = 7;
    w = 8;
    h = 8;
    return self;
}

- setAngle:(double)theta
{
    dest_x = x+480.0*cos(theta);
    dest_y = y-480.0*sin(theta);
    return self;//[super setX:x_ Y:y_];
}

- setDestX:(double)x_ Y:(double)y_
{
    dest_x = x_;
    dest_y = y_;
    return self;
}

/* - (void) draw:(BITMAP *)dest */
/* { */
/*     if (health < 1) */
/*     line(dest, x-offsetX, y-offsetY, dest_x-offsetX, dest_y-offsetY, makecol(0xff,00,0)); */
/* } */

- (enum THING_UPDATE_STATE) update
{
    double delta_x, delta_y;

    health--;

    if (health < -7)
	return THING_DEAD;
    else if (health < 0)
	return THING_NORMAL;

    delta_x = dest_x - x;
    delta_y = dest_y - y;

    if (!zeus) {
	zeus = SPAWN_CANDY(ZeusEffect, x, y, LOW_LAYER);
	[zeus setDestX:dest_x Y:dest_y];
/* 	[zeus setDestX:x+delta_x * (5-health)/5 Y:y+delta_y * (5-health)/5]; */
    }

    return THING_NORMAL;
}

- (int) damage
{
    return 1;
}

- (int) collisionRoutinePriority
{
    /* Higher priority than normal units, lower than nukes (although
       it shouldn't matter). */
    return 91;
}

- (BOOL) checkCollisionWith:(Thing<DetectsCollision> *)object
{
    double ux, uy, Delta_x, Delta_y, m;

    /* A few tics delay before actually hurting the player. */
    if (health > 1) {
	return NO;
    }

    [object getX:&ux Y:&uy];

    if (((x <= ux && ux <= dest_x) || (dest_x <= ux && ux <= x)) && 
	((y <= uy && uy <= dest_y) || (dest_y <= uy && uy <= y)));
    else {
	return NO;
    }

    Delta_x = ux-x;
    Delta_y = uy-y;

    m = (dest_y-y) / (dest_x-x);

    if (ABS(m*Delta_x - Delta_y) < 12.0) {
	return YES;
    }

    if (ABS(Delta_y/m - Delta_x) < 12.0) {
	return YES;
    }

    return NO;
}
@end
