/* laser.m,
 *
 * Lasers penetrate through an enemy if it has the strength, killing
 * as many units in its path as possible.  An ally projectile.
 */

#include <math.h>
#include "candy/line-spark.h"
#include "candy/spark.h"
#include "common.h"
#include "projectiles/laser.h"
#include "seborrhea/seborrhea.h"
#include "sound.h"
#include "unit.h"


#define LEVEL0_DAMAGE	90
#define LEVEL1_DAMAGE	60	/* note: 2 fired. */
#define LEVEL2_DAMAGE	150


static Sebum<SebSample> *fire_sample;

/*--------------------------------------------------------------*/

@interface LaserHigh: Laser
@end

/*--------------------------------------------------------------*/

@implementation Laser
+ initialize
{
    fire_sample = [base_sebum getSebumByName:"weapon/laser-snd"];
    return self;
}

- init
{
    [super init];

    health = LEVEL0_DAMAGE;
    speed = 14.0;
    angle = M_PI_2;

    sprite = [base_sebum getSebumByName:"weapon/laser"];
    w = 10;	//[sprite width]+4;
    h = 40;	//[sprite height];

    return self;
}

+ (enum DAMAGE_TYPE) damageType
{
    return DAMAGE_TYPE_LASER;
}

- (int) damage
{
    return MIN(health, 25);
}

- (int) receiveDamage:(int)damage
{
    int i;

    damage = MIN(damage, health);
    health -= damage;

    /* Slow down when penetrating an enemy. */
    speed = MAX(8.0, speed - 1.8);
    recalculate_velocity = YES;

    spawn_candy([Spark class], x, y, MEDIUM_LAYER);

    /* Some extra sparks. */
    for (i = 0; i < 2*candy_amount; i++)
	[spawn_candy([LineSpark class], x, y, HIGH_LAYER)
		    setAngle:deg2rad(rnd(-180, 0))];

    if (health <= 0)
	[self die];

    return damage;    
}
@end

/*------------------------------------------------------------*/

@implementation LaserMedium
- init
{
    [super init];
    health = LEVEL1_DAMAGE;
    return self;
}
@end

/*------------------------------------------------------------*/

@implementation LaserHigh
- init
{
    [super init];

    health = LEVEL2_DAMAGE;

    sprite = [base_sebum getSebumByName:"weapon/laser-fat"];
    w = 25;	//[sprite width]+4;
    h = 80;	//[sprite height];

    return self;
}

- (int) receiveDamage:(int)damage
{
    if (health > 100 && health-damage <= 100) {
	sprite = [base_sebum getSebumByName:"weapon/laser-high"];
	w -= 5;			/* 25px -> 20px. */
	h -= 20;		/* 80px -> 60px. */
    }
    else if (health > 50 && health-damage <= 50) {
	sprite = [base_sebum getSebumByName:"weapon/laser"];
	w -= 10;		/* 20px -> 10px. */
	h -= 20;		/* 60px -> 40px. */
    }

    return [super receiveDamage:damage];
}
@end

/*------------------------------------------------------------*/

void fireLaser(double x, double y, primary_weapon_t *w, const int pid)
{
#define SPAWN_ALLY_PROJ(p,x,y)		[(Laser *)spawn_projectile([p class],x,y,YES) setParentID:pid]

    y -= 10;
    if (w->level == 0) {
	SPAWN_ALLY_PROJ(Laser, x, y);
    }
    elif (w->level == 1) {
	/* Angle away slightly. */
	[SPAWN_ALLY_PROJ(LaserMedium, x-16, y) setAngle:deg2rad(91.5)];
	[SPAWN_ALLY_PROJ(LaserMedium, x+16, y) setAngle:deg2rad(89.5)];
    }
    else {
	SPAWN_ALLY_PROJ(LaserHigh, x, y);
    }

    w->tics = 13 + w->level;
    play_voice_on_channels(fire_sample, x, 192, PRIMARY_WEAPON_CHANNELS);

#undef SPAWN_ALLY_PROJ
}
