/* fireball.m,
 *
 * Fireballs are small, slow (but otherwise just as dangerous) enemy
 * projectiles.  They have an animation on impact.
 */

#include "candy.h"
#include "common.h"
#include "projectiles/fireball.h"
#include "seborrhea/seborrhea.h"


static SebFile *proj_data;

/*--------------------------------------------------------------*/

@interface FireballDeath: AnimatedCandyNoLoop
@end

/*------------------------------------------------------------*/

@implementation Fireball
+ derive_registerProjectile();
+ derive_loadDataProjectile(proj_data, "data/proj-fireball");
+ derive_shutdownProjectile(proj_data);

- init
{
    [super init];

    speed = rnd_with_rng(12, 24) / 10.0;

    sprite = [proj_data getSebumByName:"fireball"];
    w = 8;	//[sprite width]-2;
    h = 8;	//[sprite height]-2;

    return self;
}

- (void) die
{
    spawn_candy([FireballDeath class], x, y, HIGH_LAYER);
    [super die];
}
@end

/*------------------------------------------------------------*/

@implementation FireballDeath
- init
{
    [super init];
    speed = 0.0;
    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)
				[proj_data getSebumByName:"death"]];
    return self;
}
@end
