/* pregen-circles.m,
 *
 * Pregenerated circles for speed.  A big, fat file, which also makes
 * the executable fat.  Used mainly for nukes.
 */

#include <allegro.h>
#include <assert.h>
#include "maybe-fblend.h"
#include "pregen-circles.h"


struct span_list { 
    unsigned int h; 
    unsigned int *half_width; 
};
#include "pregen-circles.inc"


/* Draw a normal circle.  Slightly slower than Allegro's circle, but it looks
 * better. */
void pregen_circle(BITMAP* const dest, int x, int y,
		   const int r, const int c)
{
    struct span_list *circle;
    unsigned int j, hh;
    int x1, x2;

/*  r = MID(MIN_CIRCLE_RADIUS, r, MAX_CIRCLE_RADIUS); */
    assert(r <= MAX_CIRCLE_RADIUS);
    circle = circles[MAX(MIN_CIRCLE_RADIUS, r)];
    hh = circle->h / 2;
    y -= hh;

    /* Top-most row. */
    x1 = x - circle->half_width[0];
    x2 = x + circle->half_width[0];
    hline(dest, x1, y, x2, c);

    for (j = 1, y++; j < hh; j++, y++) {
        int w1 = circle->half_width[j];
        int w2 = circle->half_width[j-1];

        if (w1 == w2) {
            putpixel(dest, x-w1, y, c);
            putpixel(dest, x+w1, y, c);
        }
        else {
            hline(dest, x-w1, y, x-w2, c);
            hline(dest, x+w2, y, x+w1, c);
        }
    }

    for (; j > 0; j--, y++) {
        int w1 = circle->half_width[j];
        int w2 = circle->half_width[j-1];

        if (w1 == w2) {
            putpixel(dest, x-w1, y, c);
            putpixel(dest, x+w1, y, c);
        }
        else {
            hline(dest, x-w1, y, x-w2, c);
            hline(dest, x+w2, y, x+w1, c);
        }
    }

    /* Bottom-most row. */
    x1 = x - circle->half_width[0];
    x2 = x + circle->half_width[0];
    hline(dest, x1, y, x2, c);
}


/* Draw a circle with the "add" blender, and maybe use FBlend. */
void pregen_circlefill_add(BITMAP* const dest, int x, int y,
			   const int r, const int c, const int a)
{
    struct span_list *circle;
    unsigned int j, hh;
    assert((r <= MAX_CIRCLE_RADIUS));

/*     r = MID(MIN_CIRCLE_RADIUS, r, MAX_CIRCLE_RADIUS); */
    circle = circles[MAX(MIN_CIRCLE_RADIUS, r)];
    hh = circle->h/2;
    y -= hh;

    blender_begin_primitives();
    blender_set_add(a);

    for (j = 0; j <= hh; j++, y++) {
	blender_hline_add(dest, x-circle->half_width[j], y,
			  2*circle->half_width[j], c);
    }

    for (j--; j > 0; j--, y++) {
	blender_hline_add(dest, x-circle->half_width[j], y,
			  2*circle->half_width[j], c);
    }

    blender_end_primitives();
}
