/* osd.m,
 *
 * OSD for in-game sound/music volume adjusting.
 */

#include <allegro.h>
#include <assert.h>
#include "common.h"
#include "osd.h"
#include "seborrhea/seborrhea.h"


static Sebum<SebFont> *osd_font;
OSD *osd;


@implementation OSD
+ initialize
{
    osd_font = [base_sebum getSebumByName:"fonts/am20"];
    return self;
}

- init 
{
    [super init];
    tics = 0;
    return self;
}

- (void) draw:(BITMAP *)dest :(int)percentage
{
#define putChar(c,x,y)	[osd_font putChar:c To:dest X:x Y:y Colour:0x00:0xff:0x00 Decoration:DECORATION_VERTICAL_OUTLINE];

    int i;

    if (tics <= 0)
	return;

    if (not osd_font)
	return;

    tics--;
    [osd_font putString:"Music" To:dest X:10 Y:dest->h-20
	      Colour:0x00:0xff:0x00 Decoration:DECORATION_VERTICAL_OUTLINE];

    for (i = 0; i < percentage*25/100; i++) {
	putChar('>', 80+i*10, dest->h-20);
    }

    for (; i < 25; i++) {
	putChar('-', 80+i*10, dest->h-17);
    }
}

- (void) reset
{
    tics = 50;
}
@end
