/* newmenu-demo.m,
 *
 * Menu to pick a demo to play.
 */

#include <allegro.h>
#include <assert.h>
#include <dirent.h>
#include "common.h"
#include "newmenu-demo.h"
#include "newmenu-dirty.h"
#include "newmenu-fileselector.h"
#include "newmenu-log.h"
#include "newmenu.h"
#include "seborrhea/seborrhea.h"
#include "seborrhea/seborrhea-datadir.h"


/*--------------------------------------------------------------*/
/* Directory listing stuff.					*/
/*--------------------------------------------------------------*/

@interface DemoFileSelector: MenuFileSelector
@end

@implementation DemoFileSelector
static int demo_filter(const FILTER_TYPE *entry)
{
#ifdef __MINGW__
# define ENTRY_NAME		ent->name
    const struct al_ffblk *ent = entry;
#else  /* Linux */
# define ENTRY_NAME		entry->d_name
#endif

    char *ext;
    assert(entry);

    /* Ignore hidden files, but not ../ */
    if (ENTRY_NAME[0] == '.' && not streq(ENTRY_NAME, ".."))
	return 0;

    ext = strrchr(ENTRY_NAME, '.');
    if (ext) {
	ext++;

	if (streq(ext, "rec"))
	    return 1;
    }

#ifdef __MINGW__
    return 1;
#else  /* Linux */
    /* Keep directories and symlinks. */
    return (entry->d_type == DT_DIR || 
	    entry->d_type == DT_LNK);
#endif

#undef ENTRY_NAME
}

- init
{
    [super init];
    filter = demo_filter;
    font = [base_sebum getSebumByName:MENU_FONT_NAME];
    back_button = 1;
    return self;
}

- (void) drawButtons:(BITMAP *)dest :(int)t
{
#define PICK_RGB(n)	if (n == selected_button) selected_item_colour(&r,&g,&b,t); else r = 0xf0-3*0x08, g = 0xa0-3*0x10, b = 0x30-3*0x08

    int r, g, b;
    int l, h = [font textHeight];

    if (file_selection_side) {
	r = 0xf0-5*0x08, g = 0xa0-5*0x10, b = 0x30-3*0x10;
	[font putString:"Play" To:dest X:dest->w-60 Y:dest->h*2/3   Colour:r:g:b Alignment:ALIGN_RIGHT Decoration:DECORATION_OUTLINE];
	[font putString:"Back" To:dest X:dest->w-60 Y:dest->h*2/3+h Colour:r:g:b Alignment:ALIGN_RIGHT Decoration:DECORATION_OUTLINE];
    }
    else {
	PICK_RGB(0); [font putString:"Play" To:dest X:dest->w-60 Y:dest->h*2/3   Colour:r:g:b Alignment:ALIGN_RIGHT Decoration:DECORATION_OUTLINE];
	PICK_RGB(1); [font putString:"Back" To:dest X:dest->w-60 Y:dest->h*2/3+h Colour:r:g:b Alignment:ALIGN_RIGHT Decoration:DECORATION_OUTLINE];
    }

    l = [font textLength:"Back"];
    mark_dirty_rectangle(dest->w-60-l, dest->h*2/3, l, h*2);

#undef PICK_RGB
}
@end

/*--------------------------------------------------------------*/

char *select_demo(BITMAP *dbuf)
{
    char dirname[PATH_MAX];
    const char *demo_filename = NULL;
    DemoFileSelector *demo_list;
    Sebum<SebImage> *bg;
    BOOL exit = NO, redraw = YES;
    int t;

    demo_list = [DemoFileSelector new];

    /* Try ~/.raidem/demos/ */
    snprintf(dirname, sizeof(dirname), "%s/%s/demos/",
	     homedir, RAIDEM_CONFIG_PATHNAME);
    if ([demo_list scanDirectory:dirname])
	goto next;

    /* Try seborrhea root directories/demos/. */
    for (t = 0; seborrhea_data_root_directories[t]; t++) {
	char canonical_name[PATH_MAX];

	snprintf(dirname, sizeof dirname, "%s/demos/",
		 seborrhea_data_root_directories[t]);

	/* Use the old name for compatability with Allegro 4.0.x */
	fix_filename_path(canonical_name, dirname, sizeof canonical_name);

	if ([demo_list scanDirectory:canonical_name])
	    break;

	/* Last resort if we don't find a demo directory. */
	if (not seborrhea_data_root_directories[t+1])
	    [demo_list scanDirectory:raid_binary_directory];
    }

 next:
    mark_entire_screen_dirty();

    t = 0;
    bg = [menu_sebum getSebumByName:"backdrop"];

    while (not (exit || emergency_exit)) {
	while (counter) {
	    counter--;
	    redraw = YES;

	    t += 12;
	    if (t >= 360)
		t = 0;

	    menu_common_update();
	    update_log();
	    exit = [demo_list update:&demo_filename];
	    rest(0);
	}

	if (redraw) {
	    redraw = NO;

	    [bg drawTo:dbuf X:0 Y:0 W:dbuf->w H:dbuf->h];
	    [demo_list draw:dbuf :t];
	    draw_log(dbuf);

	    blit_dirty_rectangles(dbuf, screen);
	}
    }

    [demo_list free];
    if (demo_filename)
	return strdup(demo_filename);
    else
	return NULL;
}

