/* newmenu-custom.m,
 *
 * Menu to pick any map to play.  Future versions should support user
 * made campaigns.
 */

#include <allegro.h>
#include <assert.h>
#include <dirent.h>
#include "common.h"
#include "input.h"
#include "map-save.h"
#include "newmenu-custom.h"
#include "newmenu-dirty.h"
#include "newmenu-fileselector.h"
#include "newmenu-log.h"
#include "newmenu.h"
#include "player.h"
#include "seborrhea/seborrhea-datadir.h"


/*--------------------------------------------------------------*/
/* Directory listing stuff.					*/
/*--------------------------------------------------------------*/

@interface MapFileSelector: MenuFileSelector
@end

@implementation MapFileSelector
static int map_filter(const FILTER_TYPE *entry)
{
#ifdef __MINGW__
# define ENTRY_NAME		ent->name
    const struct al_ffblk *ent = entry;
#else  /* Linux */
# define ENTRY_NAME		entry->d_name
#endif

    char *ext;
    assert(entry);

    /* Ignore hidden files, but not ../ */
    if (ENTRY_NAME[0] == '.' && not streq(ENTRY_NAME, ".."))
	return 0;

    ext = strrchr(ENTRY_NAME, '.');
    if (ext) {
	ext++;

	if (streq(ext, RAID_MAP_EXTENSION))
	    return 1;
    }

#ifdef __MINGW__
    return 1;
#else  /* Linux */
    /* Keep directories and symlinks. */
    return (entry->d_type == DT_DIR || 
	    entry->d_type == DT_LNK);
#endif

#undef ENTRY_NAME
}

- init
{
    [super init];
    filter = map_filter;
    font = [base_sebum getSebumByName:MENU_FONT_NAME];
    back_button = 2;
    return self;
}

- (BOOL) updateOkayReleased:(const char **)buf
{
    if (not file_selection_side && selected_button == 0) {
	/* Single/two player option. */
	if (++num_players > MAX_PLAYERS)
	    num_players = 1;
	return NO;
    }
    else {
	return [super updateOkayReleased:buf];
    }
}

- (void) drawButtons:(BITMAP *)dest :(int)t
{
#define PICK_RGB(n)	if (n == selected_button) selected_item_colour(&r,&g,&b,t); else r = 0xf0-3*0x08, g = 0xa0-3*0x10, b = 0x30-3*0x08

    const char *num_players_text[MAX_PLAYERS] = { "1 Player", "2 Players" };
    int r, g, b;
    int l, h = [font textHeight];

    if (file_selection_side) {
	r = 0xf0-5*0x08, g = 0xa0-5*0x10, b = 0x30-3*0x10;
	[font putString:num_players_text[num_players-1] To:dest X:dest->w-40 Y:dest->h*1/3 Colour:r:g:b Alignment:ALIGN_RIGHT Decoration:DECORATION_OUTLINE];
	[font putString:"Play" To:dest X:dest->w-60 Y:dest->h*2/3   Colour:r:g:b Alignment:ALIGN_RIGHT Decoration:DECORATION_OUTLINE];
	[font putString:"Back" To:dest X:dest->w-60 Y:dest->h*2/3+h Colour:r:g:b Alignment:ALIGN_RIGHT Decoration:DECORATION_OUTLINE];
    }
    else {
	PICK_RGB(0); [font putString:num_players_text[num_players-1] To:dest X:dest->w-40 Y:dest->h*1/3 Colour:r:g:b Alignment:ALIGN_RIGHT Decoration:DECORATION_OUTLINE];
	PICK_RGB(1); [font putString:"Play" To:dest X:dest->w-60 Y:dest->h*2/3   Colour:r:g:b Alignment:ALIGN_RIGHT Decoration:DECORATION_OUTLINE];
	PICK_RGB(2); [font putString:"Back" To:dest X:dest->w-60 Y:dest->h*2/3+h Colour:r:g:b Alignment:ALIGN_RIGHT Decoration:DECORATION_OUTLINE];
    }

    l = [font textLength:num_players_text[1]];
    mark_dirty_rectangle(dest->w-40-l, dest->h*1/3, l+1, h);
    l = [font textLength:"Back"];
    mark_dirty_rectangle(dest->w-60-l, dest->h*2/3, l, h*2);

#undef PICK_RGB
}
@end

/*--------------------------------------------------------------*/

char *select_custom_level(BITMAP *dbuf)
{
    const char *level_filename = NULL;
    MapFileSelector *map_list;
    Sebum<SebImage> *bg;
    BOOL exit = NO, redraw = YES;
    int t;

    /* Scan all of the seborrhea root directories. */
    map_list = [MapFileSelector new];
    for (t = 0; seborrhea_data_root_directories[t]; t++) {
	char dirname[PATH_MAX], canonical_name[PATH_MAX];

	snprintf(dirname, sizeof dirname, "%s/maps/",
		 seborrhea_data_root_directories[t]);

	/* Use the old name for compatability with Allegro 4.0.x */
	fix_filename_path(canonical_name, dirname, sizeof canonical_name);

	if ([map_list scanDirectory:canonical_name])
	    break;

	/* This is the last directory to try.  Not maps directory
	   found, so just go to the raid binary directory. */
	if (not seborrhea_data_root_directories[t+1])
	    [map_list scanDirectory:raid_binary_directory];
    }

    bg = [menu_sebum getSebumByName:"backdrop"];
    mark_entire_screen_dirty();

    while (not (exit || emergency_exit)) {
	while (counter) {
	    counter--;
	    redraw = YES;

	    t += 12;
	    if (t >= 360)
		t = 0;

	    menu_common_update();
	    update_log();
	    exit = [map_list update:&level_filename];
	    rest(0);
	}

	if (redraw) {
	    redraw = NO;

	    [bg drawTo:dbuf X:0 Y:0 W:dbuf->w H:dbuf->h];
	    [map_list draw:dbuf :t];
	    draw_log(dbuf);

	    blit_dirty_rectangles(dbuf, screen);
	}
    }

    [map_list free];
    if (level_filename)
	return strdup(level_filename);
    else
	return NULL;
}
