/* mmpk.m,
 *
 * Emulation file routines for reading from memory.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mmpk.h"


int mmpk_feof(MEMORY_FILE *f)
{
    return (f->pos >= f->data+f->len);
}


long mmpk_fread(void *p, long n, MEMORY_FILE *f)
{
    if (f->pos+n >= f->data+f->len)
	n = f->data + f->len - f->pos;

    memcpy(p, f->pos, n);
    f->pos += n;
    return n;
}


int mmpk_getc(MEMORY_FILE *f)
{
    assert(f);

    if (f->pos >= f->data+f->len)
	return EOF;
    else {
	unsigned char r;
	r = *(f->pos);
	(f->pos)++;
	return r;
    }
}


int mmpk_igetw(MEMORY_FILE *f)
{
   int b1, b2;
   assert(f);

   if ((b1 = mmpk_getc(f)) != EOF)
      if ((b2 = mmpk_getc(f)) != EOF)
	 return ((b2 << 8) | b1);

   return EOF;
}


long mmpk_igetl(MEMORY_FILE *f)
{
   int b1, b2, b3, b4;
   assert(f);

   if ((b1 = mmpk_getc(f)) != EOF)
      if ((b2 = mmpk_getc(f)) != EOF)
	 if ((b3 = mmpk_getc(f)) != EOF)
	    if ((b4 = mmpk_getc(f)) != EOF)
	       return (((long)b4 << 24) | ((long)b3 << 16) |
		       ((long)b2 << 8) | (long)b1);

   return EOF;
}


char *mmpk_fgets(char *p, int max, MEMORY_FILE *f)
{
    char *curr = p;
    assert(p != NULL);
    assert(f != NULL);

    while (max > 1) {
#if 0
	*curr = mmpk_getc(f);

	if (*curr == '\n')
	    break;
	if (*curr == EOF)
	    return NULL;

	curr++;
	max--;
#else
        int c = mmpk_getc(f);
        if (c == '\n')
            break;
        if (c == EOF)
            return NULL;

        *curr = c;
        curr++;
        max--;
#endif
    }

    *curr = '\0';
    return p;
}


int mmpk_fseek(MEMORY_FILE *f, long offset, int whence)
{
    assert(f);

    if (whence == SEEK_SET)
	f->pos = f->data + offset;
    else if (whence == SEEK_END)
	f->pos = f->data + f->len - offset;
    else if (whence == SEEK_CUR)
	f->pos += offset;
    else
	return -1;

    if (f->pos < f->data)
	f->pos = f->data;
    if (f->pos >= f->data + f->len - 1)
	f->pos = f->data + f->len - 1;
    return 0;
}


long mmpk_ftell(MEMORY_FILE *f)
{
    assert(f);
    return f->pos - f->data;
}


void mmpk_rewind(MEMORY_FILE *f)
{
    assert(f);
    f->pos = f->data;
}


int mmpk_fclose(MEMORY_FILE *f)
{
    if (f) {
	free(f->data);
	free(f);
    }

    return 0;
}
