/* maybe-fblend.m,
 *
 * Wrapper for fblend routines.  Disable FBlend by adding 'NO_FBLEND'
 * to CFLAGS.
 */

#include <assert.h>
#include "maybe-fblend.h"


#ifndef NO_FBLEND

#include "fblend/include/fblend.h"

static int blender_alpha;


void _blender_set_alpha(const int alpha)
{
    blender_alpha = alpha;
}


void blender_rect_add(BITMAP* const bmp,
		      const int x, const int y,
		      const int w, const int h, const int c)
{
    fblend_rect_add(bmp, x, y, w, h, c, blender_alpha);
}


void blender_rect_trans(BITMAP* const bmp,
			const int x, const int y,
			const int w, const int h, const int c)
{
    fblend_rect_trans(bmp, x, y, w, h, c, blender_alpha);
}


#else				/* Normal Allegro routines. */


void blender_begin_primitives(void)
{
    drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
}


void blender_end_primitives(void)
{
    drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
}


void _blender_hline(BITMAP* const bmp,
		    const int x, const int y,
		    const int w, const int c)
{
    hline(bmp, x, y, x+w-1, c);
}


void _blender_rectfill(BITMAP* const bmp,
		       const int x, const int y,
		       const int w, const int h, const int c)
{
    rectfill(bmp, x, y, x+w-1, y+h-1, c);
}

#endif				/* End: NO_FBLEND */
