/* unit-mapextras.m,
 *
 * Some common drawMapEditorExtras routines.
 */

#include <allegro.h>
#include <math.h>
#include "pregen-circles.h"
#include "map.h"
#include "map-editor/unit-extras.h"

#define cyan		makecol(0x80, 0xff, 0xff)
#define green		makecol(0x40, 0xa0, 0x40)
#define pink		makecol(0xff, 0x80, 0x80)


void draw_activation_line(BITMAP *dest, int x, int y, int activate_y)
{
    x -= offsetX;
    y += activate_y - offsetY;

    hline(dest, x-75, y-1, x+75, cyan);
    hline(dest, x-75, y,   x+75, cyan);
    textprintf_centre(dest, font, x, y, green, "activate: %d", activate_y);
}


void draw_fixed_activation_line(BITMAP *dest, int x, int y, int activate_y)
{
    x -= offsetX;
    y += activate_y - offsetY;

    hline(dest, x-75, y-1, x+75, cyan);
    hline(dest, x-75, y,   x+75, cyan);
    textprintf_centre(dest, font, x, y, green, "activate");
}

/*------------------------------------------------------------*/

void draw_travel_range(BITMAP *dest, int x, int y, double angle, double dist)
{
    int x_, y_;

    x -= offsetX;
    y -= offsetY;
    x_ = x + dist*cos(angle);
    y_ = y - dist*sin(angle);

    line(dest, x, y, x_, y_, pink);
    pregen_circle(dest, x_, y_, 3, cyan);
    textprintf_centre(dest, font, x_, y_, green, "distance: %g", dist);
}

/*------------------------------------------------------------*/

void draw_group_num(BITMAP *dest, int x, int y, int n)
{
    textprintf_centre(dest, font, x-offsetX, y-offsetY, green, "group: %d", n);
}
