/* unit-redit.m,
 *
 * These methods are only to help REdit do its job.  Try to hide them
 * from being access by other people..
 */

#include <allegro.h>
#include <assert.h>
#include <math.h>
#include "common.h"
#include "map.h"
#include "map-editor/unit-editor.h"
#include "pregen-circles.h"


@implementation Unit (MapEditor)
- (BOOL) reditSetX:(double)x_ Y:(double)y_
{
    double old_x = x;
    double old_y = y;

    [self setX:x_ Y:y_];

    return ((x != old_x) || (y != old_y));
}

- (void) drawTo:(BITMAP *)dest at:(int)x_ :(int)y_
{
    int w_, h_;
    assert(sprite);

    w_ = [sprite width];
    h_ = [sprite height];

    if (w_ <= 64 && h_ <= 64) {
	x_ += (64-w_)/2;
	y_ += (64-h_)/2;

	[sprite drawTo:dest X:x_ Y:y_];
    }
    else {
	double ratio = MIN(64.0/w_, 64.0/h_);
	x_ += 64/2;
	y_ += 64/2;

	[sprite drawTo:dest X:x_ Y:y_ Angle:0.0 Scale:ratio];
    }
}

- (void) drawMapEditorExtras:(BITMAP *)dest
{
    int c = makecol(0x40, 0xa0, 0x40);
    int x_ = x - offsetX, y_ = y - offsetY;
    int w_, h_, r;

    [self getW:&w_ H:&h_];
    r = MAX(w_, h_) / 2;

    /* Circle to show tagged-ness, and the angle. */
    pregen_circle(dest, x_, y_, r+5, makecol(0x80, 0xff, 0xff));
    line(dest, x_, y_, x_+r*cos(angle), y_-r*sin(angle), makecol(0xff, 0x80, 0x80));

    /* Some quantitative information about our unit. */
    textprintf_centre(dest, font, x_, y_+h_/2, c, "%s (%g, %g @ %gdeg)",
		      [self name], x, y, rad2deg(angle));

    {				/* Powerups. */
	char str[1024] = "Powerups: \0";

	if (flags & FLAG_DEATH_SPAWN_PRIMARY_POWERUP)
	    strcat(str, "Primary ");
	if (flags & FLAG_DEATH_SPAWN_SECONDARY_POWERUP)
	    strcat(str, "Secondary ");
	if (flags & FLAG_DEATH_SPAWN_TERTIARY_POWERUP)
	    strcat(str, "Tertiary ");
	if (flags & FLAG_DEATH_SPAWN_HEALTH_POWERUP)
	    strcat(str, "Health ");
	if (flags & FLAG_DEATH_SPAWN_NUKE_POWERUP)
	    strcat(str, "Nuke");
	if (strcmp(str, "Powerups: ") != 0)
	    textout_centre(dest, font, str, x_, y_+h_/2+10, c);
    }

    if (flags & FLAG_ONLY_SPAWN_IN_TWO_PLAYER)
	textout_centre(dest, font, "(2p)", x_, y_-h_/2-10, c);
}

- (void) toggleFlag:(int)f
{
    flags ^= f;
}
@end
