/* tile-connection.m,
 *
 * This file contains a list of the simple connection tiles between
 * two tiles to help with map editing.
 */

#include <assert.h>
#include <stdlib.h>
#include "common.h"
#include "map-editor/tile-connection.h"


typedef struct {
    const char *swapee, *matchee;
} identical_tile_t;

static const identical_tile_t name_matchee[];

/*--------------------------------------------------------------*/

const char *rename_tile(const char *name)
{
    int i;

    for (i = 0; name_matchee[i].matchee; i++) {
	if (streq(name, name_matchee[i].matchee))
	    return name_matchee[i].swapee;
    }

    return name;
}

int find_in_set(const char *name, int j)
{
    const char *name2 = rename_tile(name);
    unsigned int i;

    for (i = 0; i < connection_set[j].n_items; i++) {
	if (streq(name2, connection_set[j].data[i].tile_name)) {
	    return i;
	}
    }

    return -1;
}


int find_tile_connection_set_by_name(const char *name)
{
    int j;

    for (j = 0; j < MAX_SETS; j++) {
	if (find_in_set(name, j) >= 0)
	    return j;
    }

    return -1;
}


/*--------------------------------------------------------------*/
/* Horrible mess follows.					*/
/*--------------------------------------------------------------*/

static const identical_tile_t name_matchee[] = {
    { "set0-009",	"set0-011" },
    { "set0-009",	"set0-015" },
    { "set1b-005",	"set1b-009" },
    { NULL, NULL }
};


connection_set_t connection_set[] = {
	/* Desert */
#include "map-editor/connect-desert-rock.inc"
,
#include "map-editor/connect-desert-road.inc"
,
#include "map-editor/connect-desert-road1.inc"
,
#include "map-editor/connect-desert-road2.inc"
,

	/* Space */
#include "map-editor/connect-space-platform.inc"
,
#include "map-editor/connect-space-norad.inc"
,
#include "map-editor/connect-space-ship.inc"
,
#include "map-editor/connect-space-starport.inc"
,
#include "map-editor/connect-space-building2.inc"
,
#include "map-editor/connect-space-building4.inc"
,

	/* Water */
#include "map-editor/connect-water-crack1.inc"
,
#include "map-editor/connect-water-crack2.inc"
,
#include "map-editor/connect-water-skidl.inc"
,
#include "map-editor/connect-water-skidr.inc"

};
