/* palette-tile.m,
 */

#include <allegro.h>
#include "common.h"
#include "map-editor/palette-tile.h"
#include "map-editor/tile-connection.h"
#include "tile.h"


#define ITEM_W	(TILE_W+4)
#define ITEM_H	(TILE_H+4)


@implementation PaletteTile
- init
{
    [super init];
    [label setText:"Tiles"];
    return self;
}

+ (unsigned int) countItems
{
    return num_tiles();
}

- (void) selectLMBItem:(int)n
{
    [map_proc setSelectedLMBItem:n];
}

- (void) selectRMBItem:(int)n
{
    [map_proc setSelectedRMBItem:n];
}

- (void) receiveMessage:(int)msg :(int)data
{
    if ((msg == MSG_MOUSE_HELD) && (data == 1)) {
	int x_ = mouse_x - x, y_ = mouse_y - y;

	if ((x_ < 0) || //(x_ >= items_per_row) ||
	    (y_ < 0))// || (y_ >= items_per_col))
	    return;
	
	rmb_item = (y_/ITEM_H + scrolly)*[self itemsPerRow] + (x_/ITEM_W);
	[self selectRMBItem:rmb_item];
	flags |= FLAG_DIRTY;
	return;
    }

    [super receiveMessage:msg :data];
}

- (void) drawLittleStar:(BITMAP *)dest :(int)xx :(int)yy
{
    const char *star[11] = {
	"     -     ",
	"    -.-    ",
	"----...----",
	" -.......- ",
	"  --...--  ",
	"   -...-   ",
	"  -..-..-  ",
	" -.-- --.- ",
	" --     -- "
    };

    int i, j;
    int c1, c2, c;

    c1 = makecol(0xff, 0xff, 0x00);
    c2 = makecol(0x00, 0x00, 0x00);
    for (j = 0; j < 9; j++) {
	for (i = 0; i < 11; i++) {

	    if (star[j][i] == '.')
		c = c1;
	    else if (star[j][i] == '-')
		c = c2;
	    else
		continue;

	    putpixel(dest, xx+i, yy+j, c);
	}
    }
}

- (void) drawNthItem:(BITMAP *)dest :(unsigned int)nth :(int)xx :(int)yy
{
    Sebum<SebImage> *tile;

    /* Special for RMB tile. */
    if (nth == (unsigned)rmb_item) {
	rectfill_wh(dest, xx-2, yy-2, ITEM_W, ITEM_H, green);
    }

    tile = get_tile_by_index(nth);
    [tile drawTo:dest X:xx Y:yy W:TILE_W H:TILE_H];

    if (find_tile_connection_set_by_name([tile name]) >= 0) {
	[self drawLittleStar:dest :xx+2 :yy+2];
    }
}
@end
