/* palette-switcher.m,
 *
 * Dummy widget that holds a palette proc, and helps switch editing
 * modes.
 */

#include "map-editor/palette-switcher.h"


@implementation PaletteSwitcher
- init
{
    [super init];
    min_width = 32;
    return self;
}

- setX:(int)x_ Y:(int)y_ W:(int)w_ H:(int)h_
{
    [super setX:x_ Y:y_ W:w_ H:h_];
    [active_child setX:x Y:y W:w H:h];
    return self;
}

- free
{
    unsigned int i;

    for (i = 0; i < NUM_MODES; i++)
	child[i] = [child[i] free];
    active_child = nil;

    return [super free];
}

- (Widget *) getWidgetBounding:(int)mx :(int)my
{
    return [active_child getWidgetBounding:mx :my];
}

- (void) receiveMessage:(int)msg :(int)data
{
    if (msg == MSG_REDRAW) 
	flags |= FLAG_DIRTY;

    [active_child receiveMessage:msg :data];
}

- (BOOL) draw:(BITMAP *)dest :(BOOL)marked_dirty
{
    marked_dirty = [super draw:dest :marked_dirty];
    return [active_child draw:dest :marked_dirty];
}

- (void) setChild:(unsigned int)editing_mode :(Widget *)widget
{
    child[editing_mode] = widget;
}

- (void) activateChild:(unsigned int)editing_mode
{
    active_child = child[editing_mode];
    [active_child setX:x Y:y W:w H:h];
    flags |= FLAG_DIRTY;
}
@end
