/* palette-proc.m,
 */

#include <allegro.h>
#include <assert.h>
#include <math.h>
#include "gui/gui-raid.h"
#include "map-editor/palette-proc.h"
#include "map.h"
#include "seborrhea/seborrhea-allegro.h"
#include "seborrhea/seborrhea.h"


#define ITEM_W	(TILE_W+4)
#define ITEM_H	(TILE_H+4)


#define rectfill_wh(b,x,y,w,h,c)	rectfill(b,x,y,x+w-1,y+h-1,c)


@interface AbstractPaletteProc (Private)
- (void) correctScrollbarPrecision;
@end


@implementation AbstractPaletteProc
+ (unsigned int) countItems { return 0; }

- init
{
    [super init];

    vscrollbar = [[[RaidVScrollbar newWithName:"Palette Scrollbar"]
		      setHPadding:1 VPadding:0]
		     setParentWidget:self];
    [[vscrollbar slider] setHandleH:100];

    label = [[Label newWithName:"Palette Label"]
		setMaxHeight:15];

    return self;
}

- (id) setX:(int)x_ Y:(int)y_ W:(int)w_ H:(int)h_
{
    int sw;

    [super setX:x_ Y:y_ W:w_ H:h_];

    [label setX:x_ Y:y+h-15 W:w_ H:15];

    sw = [vscrollbar maxWidth];
    [vscrollbar setX:x+w-sw Y:y W:sw H:h-15];

    [self correctScrollbarPrecision];

    return self;
}

- free
{
    vscrollbar = [vscrollbar free];
    label = [label free];
    return [super free];
}

- (Widget *) getWidgetBounding:(int)mx :(int)my
{
    if ([vscrollbar getWidgetBounding:mx :my])
	return vscrollbar;

    return [super getWidgetBounding:mx :my];
}

- (void) selectLMBItem:(int)n { (void)n; }

- (void) receiveMessage:(int)msg :(int)data
{
    int mx = mouse_x, my = mouse_y;

    switch (msg) {
      case MSG_MOUSE_HELD: {
	  int x_ = mx - x, y_ = my - y;

	  if (data != 0)
	      break;

	  /* Huh? */
/* 	  x_ = (x_ - (w - [vscrollbar width]) % ITEM_W / 2) / ITEM_W; */
/* 	  y_ = (y_ - h % ITEM_H / 2) / ITEM_H; */
	  
	  if ((x_ < 0) || //(x_ >= items_per_row) ||
	      (y_ < 0))// || (y_ >= items_per_col))
	      return;

	  lmb_item = (y_/ITEM_H + scrolly)*[self itemsPerRow] + (x_/ITEM_W);
	  [self selectLMBItem:lmb_item];
	  flags |= FLAG_DIRTY;
	  break;
      }

      case MSG_MOUSE_WHEEL: {
	  int nitems = (signed)[[self class] countItems];
	  lmb_item = MID(0, lmb_item+data, nitems-1);
	  [self selectLMBItem:lmb_item];

	  if (data < 0) {
	      /* Scroll up, above the top of the palette. */
	      if ((unsigned)lmb_item < scrolly*[self itemsPerRow])
		  scrolly = (unsigned)lmb_item / [self itemsPerRow];
	  }
	  else {
	      unsigned int items_per_screen;

	      items_per_screen = [self itemsPerRow]*((h-[label height])/TILE_H);

	      /* Scroll down, beyond the bottom of the palette. */
	      if ((unsigned)lmb_item >= scrolly*[self itemsPerRow] + items_per_screen)
		  scrolly = (lmb_item - items_per_screen)/[self itemsPerRow] + 1;
	  }

	  flags |= FLAG_DIRTY;
	  break;
      }

      default:
	  [super receiveMessage:msg :data];
    }
}

- (void) receiveMessage:(int)msg :(int)data fromChild:(Widget *)child
{
    if (child == vscrollbar && msg == MSG_VSLIDER)
	scrolly = data;
    flags |= FLAG_DIRTY;
}

/*--------------------------------------------------------------*/

- (void) drawNthItem:(BITMAP *)dest :(unsigned int)nth :(int)xx :(int)yy
{
    (void)dest, (void)nth, (void)xx, (void)yy;
}

- (BOOL) draw:(BITMAP *)dest :(BOOL)marked_dirty
{
    unsigned int n, nitems;
    int xx, x1, x2;
    int yy, y1, y2;

    marked_dirty = [super draw:dest :marked_dirty];

    [vscrollbar draw:dest :marked_dirty];
    [label draw:dest :marked_dirty];

    if (!marked_dirty)
	return NO;

    n = scrolly * [self itemsPerRow];
    nitems = [[self class] countItems];
    x1 = x;
    y1 = y;
    x2 = x + w - [vscrollbar width];
    y2 = y + h - [label height];

    for (yy = y1; n < nitems && yy + ITEM_H <= y2; yy += ITEM_H) {
	for (xx = x1; n < nitems && xx + ITEM_W <= x2; xx += ITEM_W) {
	    if (n == (unsigned)lmb_item)
		rectfill_wh(dest, xx-2, yy-2, ITEM_W, ITEM_H, yellow);

	    [self drawNthItem:dest :n :xx :yy];
	    n++;
	}
    }

    return YES;
}

- (id) setMapProcWidget:(MapProc *)widget
{
    map_proc = widget;
    [self selectLMBItem:lmb_item];
    return self;
}

- (unsigned int) itemsPerRow
{
    return MAX(1, (w - [vscrollbar width]) / ITEM_W);
}
@end


@implementation AbstractPaletteProc (Private)
- (void) correctScrollbarPrecision
{
    unsigned int items_per_row = [self itemsPerRow];
    unsigned int total_rows = ceil([[self class] countItems] / items_per_row);
    unsigned int rows_per_screen = ((h-[label height]) / TILE_H);

    [vscrollbar setSliderPrecision:total_rows-rows_per_screen+1];
}
@end
