/* palette-parallax.m,
 */

#include "map-editor/palette-parallax.h"
#include "tile.h"


@implementation PaletteParallax
- init
{
    [super init];
    [label setText:"Parallax"];
    return self;
}

+ (unsigned int) countItems
{
    return num_tiles();
}

- (void) selectLMBItem:(int)n
{
    [map_proc setSelectedLMBItem:n];
}

- (void) drawNthItem:(BITMAP *)dest :(unsigned int)nth :(int)xx :(int)yy
{
    [get_tile_by_index(nth) drawTo:dest X:xx Y:yy W:TILE_W H:TILE_H];
}
@end
