/* palette-air.m,
 *
 * Palette for air enemy units.
 */

#include "map-editor/palette-air.h"
#include "map-editor/unit-editor.h"
#include "unit.h"
#include "units/all-units.h"


@implementation PaletteAirUnit
+ (unsigned int) countItems
{
    const unit_table_t* const table = &air_units_table;
    unsigned int i, n;

    for (i = 0, n = 0; i < table->num_classes; i++) {
	if (table->class_data[i].show_in_map_editor)
	    n++;
    }

    return n;
}

- (void) selectLMBItem:(int)n
{
    const unit_table_t* const table = &air_units_table;
    unsigned int i;

    for (i = 0; i < table->num_classes; i++) {
	if (table->class_data[i].show_in_map_editor) {
	    if (--n < 0) {
		[map_proc setSelectedLMBItem:i];
		[label setText:[table->class_data[i].class name]];
		return;
	    }
	}
    }
}

- (void) drawNthItem:(BITMAP *)dest :(unsigned int)nth :(int)xx :(int)yy
{
    const unit_table_t* const table = &air_units_table;
    unsigned int i;

    for (i = 0; i < table->num_classes; i++) {
	if (table->class_data[i].show_in_map_editor) {
	    if (nth == 0) {
		Unit *unit = [table->class_data[i].class new];

		[unit drawTo:dest at:xx :yy];
		[unit free];
		return;
	    }
	    else
		nth--;
	}
    }
}
@end
