#include <allegro.h>
#include "map.h"
#include "map-editor/mouse-label-proc.h"


@implementation MousePositionLabel
- (BOOL) draw:(BITMAP *)bmp :(BOOL)marked_dirty
{
    int mx = mouse_x + offsetX;
    int my = mouse_y + offsetY;


    if ((mx != last_mouse_x) ||
	(my != last_mouse_y)) {
	char str[16];

	sprintf(str, "(%03d, %03d)", mx, my);
	[self setText:str];

	last_mouse_x = mx;
	last_mouse_y = my;
    }

    return [super draw:bmp :marked_dirty];
}
@end
