/* key-names.m,
 *
 * Turn an allegro key number (KEY_*) into a string.
 */

#include <allegro.h>
#include <stdio.h>
#include <string.h>
#include "key-names.h"


char *key_to_string(char *str, int key)
{
    if (key <= 0) {
	strcpy(str, "<not set>");
	return str;
    }

    if (key <= KEY_Z) {			/*  1 ~ 26, Alphabet */
	str[0] = (key - KEY_A) + 'A';
	str[1] = '\0';
	return str;
    }

    if (key <= KEY_9) {			/* 27 ~ 36, Numbers */
	str[0] = (key - KEY_0) + '0';
	str[1] = '\0';
	return str;
    }

    if (key <= KEY_9_PAD) {		/* 37 ~ 46, Keypad */
	sprintf(str, "%d (Keypad)", (key - KEY_0_PAD));
	return str;
    }

    if (key <= KEY_F12) {		/* 47 ~ 58, F1-F12 */
	sprintf(str, "F%d", (key - KEY_F1) + 1);
	return str;
    }

    if (key == KEY_ESC)		return strcpy(str, "Trouble maker");
    if (key == KEY_TILDE)	return strcpy(str, "`");	/* 60 */
    if (key == KEY_MINUS)	return strcpy(str, "-");	/* 61 */
    if (key == KEY_EQUALS)	return strcpy(str, "=");	/* 62 */
    if (key == KEY_BACKSPACE)	return strcpy(str, "Backspace");/* 63 */
    if (key == KEY_TAB)		return strcpy(str, "Tab");	/* 64 */
    if (key == KEY_OPENBRACE)	return strcpy(str, "[");	/* 65 */
    if (key == KEY_CLOSEBRACE)	return strcpy(str, "]");	/* 66 */
    if (key == KEY_ENTER)	return strcpy(str, "Enter");	/* 67 */
    if (key == KEY_COLON)	return strcpy(str, ";");	/* 68 */
    if (key == KEY_QUOTE)	return strcpy(str, "'");	/* 69 */
    if (key == KEY_BACKSLASH)	return strcpy(str, "\\");	/* 70 */
    if (key == KEY_BACKSLASH2)	return strcpy(str, "\\"); 	/* 71 */
    if (key == KEY_COMMA)	return strcpy(str, ",");	/* 72 */
    if (key == KEY_STOP)	return strcpy(str, ".");	/* 73 */
    if (key == KEY_SLASH)	return strcpy(str, "/");	/* 74 */
    if (key == KEY_SPACE)	return strcpy(str, "Spacebar");	/* 75 */
    if (key == KEY_INSERT)	return strcpy(str, "Insert");	/* 76 */
    if (key == KEY_DEL)		return strcpy(str, "Delete");	/* 77 */
    if (key == KEY_HOME)	return strcpy(str, "Home");	/* 78 */
    if (key == KEY_END)		return strcpy(str, "End");	/* 79 */
    if (key == KEY_PGUP)	return strcpy(str, "Page Up");	/* 80 */
    if (key == KEY_PGDN)	return strcpy(str, "Page Down");/* 81 */
    if (key == KEY_LEFT)	return strcpy(str, "Left");	/* 82 */
    if (key == KEY_RIGHT)	return strcpy(str, "Right");	/* 83 */
    if (key == KEY_UP)		return strcpy(str, "Up");	/* 84 */
    if (key == KEY_DOWN)	return strcpy(str, "Down");	/* 85 */

    if (key == KEY_SLASH_PAD)	return strcpy(str, "/ (Keypad)");	/* 86 */
    if (key == KEY_ASTERISK)	return strcpy(str, "* (Keypad)");	/* 87 */
    if (key == KEY_MINUS_PAD)	return strcpy(str, "- (Keypad)");	/* 88 */
    if (key == KEY_PLUS_PAD)	return strcpy(str, "+ (Keypad)");	/* 89 */
    if (key == KEY_DEL_PAD)	return strcpy(str, ". (Keypad)");	/* 90 */
    if (key == KEY_ENTER_PAD)	return strcpy(str, "Enter (Keypad)");	/* 91 */
    if (key == KEY_PRTSCR)	return strcpy(str, "Print Screen");	/* 92 */
    if (key == KEY_PAUSE)	return strcpy(str, "Pause");		/* 93 */

    /* I don't know about these keys, let them be <unknown>. */
    //if (key == KEY_ABNT_C1)	return strcpy(str, "");		/* 94 */
    if (key == KEY_YEN)		return strcpy(str, "Compose");	/* 95 */
    //if (key == KEY_KANA)	return strcpy(str, "");	/* 96 */
    //if (key == KEY_CONVERT)	return strcpy(str, "");	/* 97 */
    //if (key == KEY_NOCONVERT)	return strcpy(str, "");	/* 98 */
    //if (key == KEY_AT)	return strcpy(str, "");		/* 99 */
    //if (key == KEY_CIRCUMFLEX)return strcpy(str, "");		/* 100 */
    //if (key == KEY_COLON2)	return strcpy(str, "");		/* 101 */
    //if (key == KEY_KANJI)	return strcpy(str, "");		/* 102 */

    if (key == KEY_LSHIFT)	return strcpy(str, "Left Shift");	/* 103 */
    if (key == KEY_RSHIFT)	return strcpy(str, "Right Shift");	/* 104 */
    if (key == KEY_LCONTROL)	return strcpy(str, "Left Control");	/* 105 */
    if (key == KEY_RCONTROL)	return strcpy(str, "Right Control");	/* 106 */
    if (key == KEY_ALT)		return strcpy(str, "Alt");		/* 107 */
    if (key == KEY_ALTGR)	return strcpy(str, "Alt GR");		/* 108 */
    if (key == KEY_LWIN)	return strcpy(str, "Left Windows");	/* 109 */
    if (key == KEY_RWIN)	return strcpy(str, "Right Windows");	/* 110 */
    if (key == KEY_MENU)	return strcpy(str, "Menu");		/* 111 */
    if (key == KEY_SCRLOCK)	return strcpy(str, "Scroll Lock");	/* 112 */
    if (key == KEY_NUMLOCK)	return strcpy(str, "Num Lock");		/* 113 */
    if (key == KEY_CAPSLOCK)	return strcpy(str, "Caps Lock");	/* 114 */

    sprintf(str, "<unknown %d>", key);
    return str;
}
