/* input-controller.m,
 *
 * Abstract input controller.
 */

#include <assert.h>
#include "common.h"
#include "input-controller.h"


@implementation InputController
- init
{
    [super init];

    auto_repeat[RAID_KEY_UP]    = YES;
    auto_repeat[RAID_KEY_DOWN]  = YES;
    auto_repeat[RAID_KEY_LEFT]  = YES;
    auto_repeat[RAID_KEY_RIGHT] = YES;
    auto_repeat[RAID_KEY_START] = NO;
    auto_repeat[RAID_KEY_MENU]  = NO;
    auto_repeat[RAID_KEY_FIRE]  = NO;

    return self;
}

/* File seeking code snucked metafile code. */
- (BOOL) seekInFile:(const char *)fn :(FILE *)fp For:(const char *)seekee
{
    int parentheses_depth = 0;
    assert(fp && seekee);

    /* Go to the start. */
    rewind(fp);

    if (not expect_char(fp, '('))
	return NO;

    do {
	Token *tok;
	parentheses_depth++;

	while ((tok = read_token(fp))) {
	    if ([tok isType:TOKEN_SYMBOL]) {
		if ((parentheses_depth == 1) &&
		    streq([tok getSymbol], seekee)) {
		    /* We found it! */
		    [tok free];
		    return YES;
		}
	    }
	    [tok free];
	}

	while (expect_char(fp, ')')) {
	    parentheses_depth--;

	    if (parentheses_depth < 0)
		goto exit_without_finding_seekee;
	}
    } while (expect_char(fp, '('));

 exit_without_finding_seekee:
    if (parentheses_depth != 0) {
	fprintf(stderr, "Mismatching parentheses in %s.\n", fn);
    }
    return NO;
}

- (void) poll
{
    int i;

    for (i = 0; i < NUM_RAID_KEYS; i++)
	was_pressed[i] = pressed[i];

    [self pollUpdatePressed];

    /* Auto repeat. */
    for (i = 0; i < NUM_RAID_KEYS; i++) {
	if ([self pressed:i])
	    repeat_tics[i] = 4;
	elif ([self released:i])
	    repeat_tics[i] = 0;
	elif ([self held:i]) {
	    if (repeat_tics[i] > 0)
		repeat_tics[i]--;
	    elif (auto_repeat[i]) {
		was_pressed[i] = 0;
		repeat_tics[i] = 2;
	    }
	}
    }
}

- (void) pollUpdatePressed
{
    /* Replace me! */
}

- (BOOL) pressed:(raid_key_t)k
{
    return (pressed[k] && not was_pressed[k]);
}

- (BOOL) held:(raid_key_t)k
{
    return pressed[k];
}

- (BOOL) released:(raid_key_t)k
{
    return (not pressed[k] && was_pressed[k]);
}

- (void) setKey:(raid_key_t)k To:(int)k_
{
    /* Replace me! */
    (void)k, (void)k_;
}

- (int) getKey:(raid_key_t)k
{
    /* Replace me! */
    (void)k;
    return 0;
}
@end
