/* help.m,
 *
 * Display command line arguments and the compilation options.
 */

#include <stdio.h>
#include "common.h"
#include "help.h"


static void display_compilation_options(void)
{
    const char str[] =			/* Yuck. */
	"\nCompile-time options: "

#ifdef CHEAT
	"CHEAT "
#endif
#ifdef NO_ALRAND
	"NO_ALRAND "
#endif
#ifdef NO_FBLEND
	"NO_FBLEND "
#endif
#ifdef NO_ID3TAGS
	"NO_ID3TAGS "
#endif
#ifdef NO_MP3
	"NO_MP3 "
#endif
#ifdef NO_OGG
	"NO_OGG "
#endif
#ifdef NO_VIDEO_BITMAPS
	"NO_VIDEO_BITMAPS"
#endif
#ifdef WINFF
	"WINFF (force feedback)"
#endif
	"\n";

    if (strneq(str, "\nCompile-time options: \n"))
	printf(str);
}


void display_help(void)
{
    printf(GAME_NAME_AND_VERSION "\n"
	   " -D, --difficulty <num>\tSet difficulty.  0 (easy) <= num <= 4 (hard)\n"
	   " -J, --jumpstart <map>\tJump straight into the game, bypassing menus\n"
	   " -1\t\t\tOne player mode (when jumpstarting)\n"
	   " -2\t\t\tTwo player mode (when jumpstarting)\n"
	   " -r, --nodemo\t\tDisable demo recording\n"

	   "\n"				/* Video. */
	   " -f, --fullscreen\tRun in fullscreen mode\n"
	   " -w, --windowed  \tRun in windowed mode\n"
	   " -d, --depth <num>\tTry to run with colour depth <num>\n"
#ifndef NO_VIDEO_BITMAPS
	   " -p, --pageflipping\tEnable page flipping\n"
	   " -P, --nopageflipping\tDisable page flipping\n"
	   " -t, --triplebuffer\tEnable triple buffering\n"
	   " -T, --notriplebuffer\tDisable triple buffering\n"
#endif

	   "\n"				/* Input. */
	   " -j, --nojoystick\tDisable joystick support\n"

	   "\n"				/* Audio. */
	   " -m, --mute\t\tDisable sound and music\n"
#ifndef NO_ID3TAGS
	   " -a, --noads\t\tDisable ID3 tag scanning\n"
#endif

	   "\n"				/* REdit options. */
	   " -e, --edit [map]\tRun the map editor, REdit\n"
	   " -W, --width <num>\tRun REdit with width <num>\n"
	   " -H, --height <num>\tRun REdit with height <num>\n"

	   "\n"				/* Extra info. */
	   " -h, --help   \t\tShow this screen and exit\n"
	   " -v, --version\t\tDisplay the name and version number\n");

    display_compilation_options();
}


void display_version(void)
{
    printf(GAME_NAME_AND_VERSION "\n");
    display_compilation_options();
}
