#include <allegro.h>
#include "gui/gui.h"
#include "gui/gui-dirty.h"


#define MAX_RECTANGLES	25


typedef struct dirty_rect_t {
    unsigned int x, y, w, h;
} dirty_rect_t;


static dirty_rect_t rects[MAX_RECTANGLES];


void add_dirty_rectangle(int x, int y, int w, int h)
{
    int i;

    for (i = 0; i < MAX_RECTANGLES; i++) {
	if ((rects[i].w <= 0) || (rects[i].h <= 0)) {
	    rects[i].x = x;
	    rects[i].y = y;
	    rects[i].w = w;
	    rects[i].h = h;
	    return;
	}
    }
}


void gui_update_dirty(BITMAP *bmp)
{
    int i;

    /* Draw them to screen. */
    for (i = 0; i < MAX_RECTANGLES; i++) {
	if ((rects[i].w <= 0) || (rects[i].h <= 0))
	    break;

	scare_mouse_area(rects[i].x, rects[i].y, rects[i].w, rects[i].h);
	blit(bmp, screen, rects[i].x, rects[i].y, rects[i].x, rects[i].y,
	     rects[i].w, rects[i].h);
	unscare_mouse();

	rects[i].w = rects[i].h = 0;
    }
}
