/* fps.m,
 *
 * Toggle FPS display using [F12].
 */

#include <allegro.h>
#include <assert.h>
#include "common.h"
#include "fps.h"
#include "game.h"


#ifdef DEBUG_FPS

static volatile int fps, prev_fps;


static void fps_ticker(void)
{
    prev_fps = fps;
    fps = 0;
}


BOOL toggle_fps(void)
{
    static BOOL held;
    BOOL was_held = held;
    held = key[KEY_F12];

    return (held && !was_held);
}


void draw_fps(BITMAP *dest)
{
    int c = makecol(0xff, 0x80, 0x80);
    assert(dest);
    fps++;

    textprintf(dest, font, 0, 0, c, "FPS: %d", prev_fps);

#ifndef NO_VIDEO_BITMAPS
    if (raid_use_triple_buffering)
	textout(dest, font, "Triple buffering", 0, 10, c);	
    elif (raid_use_page_flipping)
	textout(dest, font, "Page flipping",    0, 10, c);
    else
	textout(dest, font, "Double buffering", 0, 10, c);
#endif

#ifndef NO_FBLEND
    textout(dest, font, "FBlend", 0, 20, c);
#endif

#ifdef WINFF
    textout(dest, font, "Force Feedback", 0, 30, c);
#endif
}


void fps_init(void)
{
    install_int_ex(fps_ticker, SECS_TO_TIMER(1));
}


void fps_shutdown(void)
{
    remove_int(fps_ticker);
}

#endif /* DEBUG_FPS */
