/* enter-name.m,
 *
 * Functions to enter a player's name using either keyboard or
 * joystick.
 */

#include <assert.h>
#include <ctype.h>
#include <string.h>
#include "common.h"
#include "enter-name.h"
#include "input.h"
#include "player.h"


static int backspace_repeat_delay;


static void append_char(char *buf, const size_t sz, const char c)
{
    size_t l = strlen(buf);

    if (l+1 < sz) {
	buf[l] = c;
	buf[l+1] = '\0';
    }
}


/* Enter Name:
 *
 * Process input from keyboard and joystick, new characters to the
 * buffer 'buf', which has at most 'sz' characters (including
 * terminating byte).  'curr_char' stores the character for joystick,
 * and 'pl' is the player to read joystick input from.
 */
BOOL enter_name(char *buf, const size_t sz, char *curr_char,
		const unsigned int pl)
{
    int scroll_direction = 0;

    if (start_released())
	return YES;

    /* Keyboard. */
    if (keypressed()) {
	int c = (readkey() & 0xff);

	if (key[KEY_U] && (key_shifts & KB_CTRL_FLAG))
	    buf[0] = '\0';
	else if (isprint(c))
	    append_char(buf, sz, c);

	return NO;
    }

    /* Not inside keypressed for auto-repeat. */
    if (key[KEY_BACKSPACE]) {
	if (backspace_repeat_delay <= 0) {
	    backspace_repeat_delay = 10;
	    goto delete_character;
	}
	else
	    backspace_repeat_delay--;
    }
    else
	backspace_repeat_delay = 0;

    /* Joystick. */
    if (player_controls[pl].joystick) {
	if ([player_controls[pl].joystick pressed:RAID_KEY_UP])
	    scroll_direction++;
	if ([player_controls[pl].joystick pressed:RAID_KEY_DOWN])
	    scroll_direction--;
	if ([player_controls[pl].joystick pressed:RAID_KEY_FIRE]) {
	    append_char(buf, sz, *curr_char);
	    return NO;
	}
	if ([player_controls[pl].joystick pressed:RAID_KEY_MENU] ||
	    [player_controls[pl].joystick pressed:RAID_KEY_LEFT])
	    goto delete_character;
    }

    if (scroll_direction) {
	*curr_char += scroll_direction;

	if (*curr_char < ' ')
	    *curr_char = ' ';

	if (*curr_char > '~')
	    *curr_char = '~';
    }
    return NO;

 delete_character:
    {
	size_t l = strlen(buf);
	if (l > 0)
	    buf[l-1] = '\0';
	return NO;
    }
}
