/* demo-info.m,
 */

#include <allegro.h>
#include <assert.h>
#include <math.h>
#ifdef __MINGW__
# include <pthread.h>		/* For ctime_r. */
#endif
#include "common.h"
#include "demo-info.h"
#include "map.h"
#include "player.h"
#include "seborrhea/seborrhea.h"
#include "strlcpy.h"


#define HIGH_SCORE_NAME_LEN		20

static Sebum<SebFont> *fnt;
static Sebum<SebFont> *fnt2;
static const char *title_str;
static const char *difficulty_str;
static char demo_date_str[26];
static int demo_info_time;

static char pilot_name[MAX_PLAYERS][HIGH_SCORE_NAME_LEN+1];
static int pilot_name_time[MAX_PLAYERS];

/*--------------------------------------------------------------*/

void draw_demo_info(BITMAP *dest)
{
    if (demo_info_time > 0) {
	assert(fnt);

	[fnt putString:title_str To:dest
	     X:dest->w/2 Y:150 Colour:0xff:0xd0:0xd0
	     Alignment:ALIGN_CENTRE Decoration:DECORATION_OUTLINE];

	[fnt putString:difficulty_str To:dest
	     X:dest->w/2 Y:180 Colour:0xff:0xd0:0xd0
	     Alignment:ALIGN_CENTRE Decoration:DECORATION_OUTLINE];

	[fnt putString:demo_date_str To:dest
	     X:dest->w/2 Y:350 Colour:0xff:0xd0:0xd0
	     Alignment:ALIGN_CENTRE Decoration:DECORATION_OUTLINE];
    }
    else {
	unsigned int pl;
	double x, y;
	int l;

	for (pl = 0; pl < MAX_PLAYERS; pl++) {
	    if (not player[pl] ||
		pilot_name_time[pl] <= 0)
		continue;

	    l = [fnt2 textLength:pilot_name[pl]];
	    [player[pl] getX:&x Y:&y];

	    /* Don't go off the screen. */
	    x = x - offsetX;
	    if (x-l/2 < 5)
		x = 5;
	    elif (x+l/2 >= screen_w-5)
		x = screen_w-5-l;
	    else
		x -= l/2;

	    [fnt2 putString:pilot_name[pl] To:dest
		  X:x Y:y-offsetY-32 Colour:0xff:0xd0:0xd0
		  Decoration:DECORATION_OUTLINE];
	}
    }
}


void update_demo_info(void)
{
    if (demo_info_time > 0) {
	demo_info_time--;
    }
    else {
	unsigned int pl;

	for (pl = 0; pl < MAX_PLAYERS; pl++) {
	    if (pilot_name_time[pl] > 0)
		pilot_name_time[pl]--;
	}
    }
}


void demo_info_set_text(const char *title, const char *difficulty)
{
    fnt = [base_sebum getSebumByName:"fonts/am20"];

    title_str = title;
    difficulty_str = difficulty;

    demo_info_time = 2*SECONDS;
}


void demo_info_set_date(const time_t *date)
{
    if (date) {
	ctime_r(date, demo_date_str);

	/* Drop the newline character. */
	demo_date_str[24] = '\0';
    }
    else {
	demo_date_str[0] = '\0';
    }
}


void demo_info_set_pilot(unsigned int pl, const char *name)
{
    assert(pl <= MAX_PLAYERS);
    assert(name);

    fnt2 = [base_sebum getSebumByName:"fonts/am14"];

    strlcpy(pilot_name[pl], name, sizeof(pilot_name[pl]));
    pilot_name_time[pl] = 50;
}
