/* common.m,
 *
 * Some useful routines, and also some common variables.
 */

#include <allegro.h>
#include <math.h>
#include <objc/Object.h>
#include <stdlib.h>
#include "common.h"


/* Only useful for debugging. */
/* int game_time; */

/* The global sebum containing player, powerups, explosions, etc. */
SebFile *base_sebum;

/* Extras data for the game. */
int game_flags;

/* The directory where HOME and raid.exe are in. */
char *homedir;
char *raid_binary_directory;

/* For randomization that will affect demo playback/gameplay ONLY.
 * Others should just use the global state provided by alrand.
 */
alrand_state *rng_state;


/* Returns a random number between a and b (inclusive). */
inline int rnd(const int a, const int b)
{
    alrand_uint32_t n = alrand_rand();
    return (n % (b-a+1)) + a;
}

/* Same as rnd, but using rng instead of the global rng. */
inline int rnd_with_state(const int a, const int b, alrand_state *state)
{
    alrand_uint32_t n = alrand_generate(state);
    return (n % (b-a+1)) + a;
}


/* Makes the angle between +/-PI. */
inline void simplify_angle(double *theta)
{
    if (*theta < -M_PI)
	*theta += 2*M_PI;
    else if (*theta > M_PI)
	*theta -= 2*M_PI;
}
