/* zeus.m,
 */

#include <allegro.h>
#include <assert.h>
#include <math.h>
#include "candy/zeus.h"
#include "linklist.h"
#include "map.h"
#include "player.h"
#include "rotate.h"


#define NUM_STEPS	65
#define MAX_HEALTH	35


@implementation ZeusEffect: Candy
- init
{
    [super init];
    health = MAX_HEALTH;
    return self;
}

#if 0
    double theta = atan2(y-dest_y, dest_x-x);

    {				/* Orange killer zap. */

	cpx[0] = mux *  100*cos(theta);
	cpy[0] = mux * -100*sin(theta);
	cpx[2] = mux * -50*sin(theta)-50*cos(theta);
	cpy[2] = mux * -50*cos(theta)-50*sin(theta);

	[[cp0 setX:x Y:y steps:10]
	    setControlPoint:1 X:cpx[0] Y:cpy[0]];
	[[[cp1 setX:(x+dest_x)/2 Y:(y + dest_y)/2 steps:10]
	     setControlPoint:0 X:cpx[2] Y:cpy[2]]
	    setControlPoint:1 X:-cpx[2] Y:-cpy[2]];
	[[cp2 setX:dest_x Y:dest_y steps:1]
	    setControlPoint:0 X:-cpx[0] Y:-cpy[0]];
	[cp3 setX:dest_x Y:dest_y];

	the_path[0] = articulate_spline(list);
    }

    {				/* Pink killer zap. */
	cpx[2] = mux * -25*sin(theta);
	cpy[2] = mux * -25*cos(theta);

	[[[cp1 setX:x + (dest_x-x)/3 Y:y + (dest_y-y)/3]
	      setControlPoint:0 X:cpx[2] Y:cpy[2]]
	    setControlPoint:1 X:-cpx[2] Y:-cpy[2]];
	[cp2 setControlPoint:0 X:cpx[0] Y:cpy[0]];

	the_path[1] = articulate_spline(list);
    }
#endif

- (void) recalculateSpline
{
#define ROTATE(xx,yy,rx,ry)	rotate2(xx,yy,cos_theta,sin_theta,rx,ry)

    int i;
    ControlPoint *cp[6];
    List *list = [LIST_NEW];
    double theta = atan2(y-dest_y, dest_x-x);
    double cos_theta = cos(-theta-M_PI_2);
    double sin_theta = sin(-theta-M_PI_2);
    double cpxx, cpyy, cpx0, cpy0, cpx1, cpy1;

    for (i = 6-1; i >= 0; i--) {
	cp[i] = [ControlPoint new];
	assert(cp[i]);

	/* Insert in reverse order. */
	[list insertItem:cp[i]];
    }

#if 0
    /* Proto-type Pink killer zap.  Pre-rotation. */
    [[cp[0] setX:x Y:y steps:10]
	setControlPoint:1 X:0 Y:20];
    [[[cp[1] setX:x-20 Y:y+20 steps:10]
	 setControlPoint:0 X:10 Y:-10]
	setControlPoint:1 X:10 Y:10];
    [[[cp[2] setX:x+15 Y:y+200 steps:10]
	 setControlPoint:0 X:-20 Y:-20]
	setControlPoint:1 X:-20 Y:20];
    [[[cp[3] setX:x-10 Y:y+240 steps:10]
	 setControlPoint:0 X:20 Y:-20]
	setControlPoint:1 X:20 Y:20];
    [[[cp[4] setX:x Y:y+260 steps:10]
	 setControlPoint:0 X:-20 Y:-20]
	setControlPoint:1 X:0 Y:40];
    [cp[5] setX:x Y:y+400];
#else
    /* Pink killer zap. */
    ROTATE(0, 20, &cpx1, &cpy1);
    [[cp[0] setX:x Y:y steps:10]
	setControlPoint:1 X:cpx1 Y:cpy1];

    ROTATE(-20,  20, &cpxx, &cpyy);
    ROTATE( 10, -10, &cpx0, &cpy0);
    ROTATE( 10,  10, &cpx1, &cpy1);
    [[[cp[1] setX:x+cpxx Y:y+cpyy steps:25]
	 setControlPoint:0 X:cpx0 Y:cpy0]
	setControlPoint:1 X:cpx1 Y:cpy1];

    ROTATE( 15, 200, &cpxx, &cpyy);
    ROTATE(-20, -20, &cpx0, &cpy0);
    ROTATE(-20,  20, &cpx1, &cpy1);
    [[[cp[2] setX:x+cpxx Y:y+cpyy steps:10]
	 setControlPoint:0 X:cpx0 Y:cpy0]
	setControlPoint:1 X:cpx1 Y:cpy1];

    ROTATE(-10, 240, &cpxx, &cpyy);
    ROTATE( 20, -20, &cpx0, &cpy0);
    ROTATE( 20,  20, &cpx1, &cpy1);
    [[[cp[3] setX:x+cpxx Y:y+cpyy steps:10]
	 setControlPoint:0 X:cpx0 Y:cpy0]
	setControlPoint:1 X:cpx1 Y:cpy1];

    ROTATE(  0, 260, &cpxx, &cpyy);
    ROTATE(-20, -20, &cpx0, &cpy0);
    ROTATE(  0,  40, &cpx1, &cpy1);
    [[[cp[4] setX:x+cpxx Y:y+cpyy steps:10]
	 setControlPoint:0 X:cpx0 Y:cpy0]
	setControlPoint:1 X:cpx1 Y:cpy1];

    [cp[5] setX:dest_x Y:dest_y];
#endif

    the_path[1] = articulate_spline(list);

    [list free];

#undef ROTATE
}

- (id) setDestX:(double)dest_x_ Y:(double)dest_y_
{
    dest_x = dest_x_;
    dest_y = dest_y_;
 
    [self recalculateSpline];
    return self;
}

- (void) draw:(BITMAP *)dest
{
    int c[2], i, j, ss;
    double mux = (double)health/MAX_HEALTH;

/*     c = makecol(0xff, 0xff-0xa0*health/40, 0xff-0x5f*health/40); */
    c[0] = makecol(0xff, 0xa0 + 0x40-0x40*mux, 0x00 + 0x80-0x80*mux);
    c[1] = makecol(0xff, 0x80 + 0x40-0x40*mux, 0xc0 + 0x20-0x20*mux);

    if (health < 5)
	ss = 4;
    else if (health < 10)
	ss = 3;
    else if (health < 20)
	ss = 2;
    else
	ss = 1;

    for (i = 1; i < NUM_STEPS-1; i += ss) {
	if (0.2 * i / (NUM_STEPS-1) > 1.0-mux)
	    break;

	for (j = 1; j < 2; j++) {
	line(dest,
	     the_path[j][i-1].x - offsetX, the_path[j][i-1].y - offsetY,
	     the_path[j][i].x   - offsetX, the_path[j][i].y   - offsetY,
	     c[j]);

	line(dest,
	     the_path[j][i-1].x - offsetX, the_path[j][i-1].y - offsetY,
	     the_path[j][i+1].x - offsetX, the_path[j][i+1].y - offsetY,
	     c[j]);
	}
    }
}

- (enum THING_UPDATE_STATE) update
{
    health--;
    if (health <= 0) {
	return THING_DEAD;
    }
    else {
/* 	[self recalculateSpline]; */
	return THING_NORMAL;
    }
}
@end
