/* tank-debris.m,
 *
 * Debris left behind after a tank is destroyed.
 */

#include "common.h"
#include "candy/tank-debris.h"
#include "map.h"
#include "seborrhea/seborrhea.h"


@implementation TankDebris
- init
{
    SebLump *debs;
    SebAnimation *anim;

    [super init];

    debs = (SebLump *)[base_sebum getSebumByName:"tank-debris"];
    anim = (SebAnimation *)[debs getRandomSebum];
    sprite = [[SebAnimatorManualWithDelay new] setAnimation:anim];

    progress = 0;
    health = [anim numFrames]*[anim frameDelay];

    return self;
}

- (enum THING_UPDATE_STATE) update
{
    if (progress < health) {
	progress++;
	[(SebAnimatorManualWithDelay *)sprite nextFrame];
    }

    return [super update];
}

- (void) draw:(BITMAP *)dest
{
    if (sprite) {
	int alpha = 255 * progress/health;

	[sprite drawTo:dest
		X:x-offsetX-[sprite width]/2
		Y:y-offsetY-[sprite height]/2 Alpha:alpha];
    }
}
@end
