/* speed-shadow.m,
 *
 * Blue unit sprite trails that denote speed.
 */

#include <math.h>
#include "common.h"
#include "candy/speed-shadow.h"
#include "map.h"


@implementation SpeedShadow
- (void) draw:(BITMAP *)dest
{
    if (sprite) {
	[sprite drawTo:dest
		X:x-offsetX-[sprite width]/2
		Y:y-offsetY-[sprite height]/2
		Alpha:0xff * health/max_health];
    }
}

- (enum THING_UPDATE_STATE) update
{
    health--;
    return [super update];
}
@end


@implementation RotatedSpeedShadow
- (void) draw:(BITMAP *)dest
{
    if (sprite) {
	[sprite drawTo:dest 
		X:x-offsetX Y:y-offsetY
		Alpha:0xff * health/max_health Angle:angle];
    }
}
@end
