/* large-chunk.m,
 *
 * Large chunks spawn little chunks, but due to laziness, they are the
 * same size/colour as small chunks.
 */

#include <allegro.h>
#include <math.h>
#include "candy/chunk.h"
#include "candy/large-chunk.h"
#include "common.h"
#include "seborrhea/seborrhea.h"


#define CHUNK_MIN_SPEED		30
#define CHUNK_MAX_SPEED		45
#define CHUNK_OMEGA_MIN		5	/* degrees/frame. */
#define CHUNK_OMEGA_MAX		10
#define CHUNK_SPRAY		25	/* degrees. */


static int chunk_life[TOTAL_CANDY_LEVELS] = {
    0, 2, 3, 4, 5
};


@implementation LargeChunk
- init
{
    [super init];

    sprite = [(SebLump *)[base_sebum getSebumByName:"chunks/gray"] getRandomSebum];
    angle = deg2rad(rnd(-180, 180));
    speed = rnd(CHUNK_MIN_SPEED, CHUNK_MAX_SPEED) / 10;

    omega = deg2rad(rnd(CHUNK_OMEGA_MIN, CHUNK_OMEGA_MAX)) * (rand() % 2 == 0 ? -1 : 1);

    life = chunk_life[candy_amount];	/* Chunks to spawn. */
    small_chunk = [Chunk class];

    return self;
}

- (enum THING_UPDATE_STATE) update
{
    if (life > 0 && rnd(0, 99) < 20) {
	[spawn_candy(small_chunk, x, y, HIGH_LAYER)
		    setAngle:angle + deg2rad(rnd(-CHUNK_SPRAY, CHUNK_SPRAY))];
	life--;
    }

    return [super update];
}
@end


@implementation LargeChunkBlue
- init
{
    [super init];
    sprite = [(SebLump *)[base_sebum getSebumByName:"chunks/blue"] getRandomSebum];
    small_chunk = [ChunkBlue class];
    return self;
}
@end

@implementation LargeChunkCoffee
- init
{
    [super init];
    sprite = [(SebLump *)[base_sebum getSebumByName:"chunks/coffee"] getRandomSebum];
    small_chunk = [ChunkCoffee class];
    return self;
}
@end

@implementation LargeChunkGreen
- init
{
    [super init];
    sprite = [(SebLump *)[base_sebum getSebumByName:"chunks/green"] getRandomSebum];
    small_chunk = [ChunkGreen class];
    return self;
}
@end

@implementation LargeChunkRed
- init
{
    [super init];
    sprite = [(SebLump *)[base_sebum getSebumByName:"chunks/red"] getRandomSebum];
    small_chunk = [ChunkRed class];
    return self;
}
@end

@implementation LargeChunkSardaukar
- init
{
    [super init];
    sprite = [(SebLump *)[base_sebum getSebumByName:"chunks/sardaukar"] getRandomSebum];
    small_chunk = [ChunkSardaukar class];
    return self;
}
@end
