/* explosion.m,
 *
 * "I like it when things go kablooey, but not when it's ME!"
 */

#include <math.h>
#include "candy/explosion.h"
#include "common.h"
#include "seborrhea/seborrhea.h"
#include "sound.h"


static SebLump *small_explosions;
static SebLump *big_explosions;
static SebLump *big_explosion_sounds;


static int explosion_life[TOTAL_CANDY_LEVELS] = {
    0, 1, 2, 5, 8
};


@implementation Explosion
+ initialize
{
    small_explosions = (SebLump *)[base_sebum getSebumByName:"explosion-small"];
    return self;
}

- init
{
    [super init];

    angle = deg2rad(rnd(-180, 180));
    speed = rnd(22, 27)/10;

    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)[small_explosions getRandomSebum]];
    return self;
}
@end

/*------------------------------------------------------------*/

@implementation BigExplosion
+ initialize
{
    big_explosions = (SebLump *)[base_sebum getSebumByName:"explosion-big"];
    return self;
}

- init
{
    [super init];

    life = explosion_life[candy_amount];
    angle = deg2rad(rnd(-180, 180));
    speed = rnd(17, 27) / 10;

    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)[big_explosions getRandomSebum]];

    return self;
}

- (enum THING_UPDATE_STATE) update
{
    if (life > 0 && rnd(0, 99) < 15) {
	spawn_candy([Explosion class], x, y, HIGH_LAYER);
	life--;
    }
    return [super update];
}
@end

/*------------------------------------------------------------*/

void play_explosion_sample(const int x)
{
    if (not big_explosion_sounds)
	big_explosion_sounds = (SebLump *)[base_sebum getSebumByName:"explosion-sounds"];

    //play_panned_sample((Sebum<SebSample> *)[big_explosion_sounds getRandomSebum], 192, x);
    play_panned_sample((Sebum<SebSample> *)[big_explosion_sounds getRandomSebum], x);
}
