/* boat-sinking.m,
 *
 * Abstract class for a sinking boat.
 */

#include <allegro.h>
#include <math.h>
#include "candy/boat-sinking.h"
#include "candy/ripple.h"
#include "map.h"


@implementation BoatSinking
- init
{
    [super init];
    scale = 1.0;
    ripple_tics = 0;
    return self;
}

- (void) draw:(BITMAP *)dest
{
    [sprite drawTo:dest X:x-offsetX Y:y-offsetY Angle:angle Scale:scale];
}

- (enum THING_UPDATE_STATE) update
{
    if (scale >= 0.70)
	angle += 0.5 * M_PI / 180.0;

    if (scale >= 0.60) {
	scale -= 0.005;
	y += 0.05;

	ripple_tics--;
	if (ripple_tics <= 0) {
	    ripple_tics = 10;
	    spawn_candy([Ripple class], x, y-10, FLOOR_LAYER);
	    
	}
    }

    return [super update];
}
@end
