/* candy.m,
 *
 * Stuff that doesn't contribute to gameplay outside of eye-candy.
 * Formerly known as debri[s].  Chunks, explosions, sparks, etc.
 */

#include <allegro.h>
#include <assert.h>
#include <math.h>
#include "candy.h"
#include "common.h"
#include "linklist.h"
#include "seborrhea/seborrhea.h"


#define ASSERT_LAYER(x)		assert(x < TOTAL_LAYERS)
#define foreach_layer(x)	for (x = SUBTERRANIAN_LAYER; x < TOTAL_LAYERS; x++)


int candy_amount = 2;


static List *candy_list[TOTAL_LAYERS];


@implementation Candy
        /* Initialization. */
- init
{
    [super init];

    sprite = [base_sebum getSebumByName:"dummy8x8"];
    w = [sprite width];
    h = [sprite height];
    recalculate_velocity = YES;

    return self;
}

- (id) setAngle:(double)theta;
{
    angle = theta;
    recalculate_velocity = YES;
    return self;
}

	/* Update. */
- (enum THING_UPDATE_STATE) update
{
    /* The angle was changed, recalculate xv/yv. */
    if (recalculate_velocity) {
	xv = speed * cos(angle);
	yv = speed * sin(angle);
	recalculate_velocity = NO;
    }

    x += xv;
    y -= yv;

    return [super update];
}
@end

@implementation AnimatedCandyNoLoop: Candy
- (enum THING_UPDATE_STATE) update
{
    if (sprite && [(SebAnimator *)sprite animationEnded])
	return THING_DEAD;

    return [super update];
}
@end

/*------------------------------------------------------------*/

void draw_candy(BITMAP *dest, enum CANDY_LAYER layer)
{
    ListIterator *it;
    ASSERT_LAYER(layer);

    foreach (it, candy_list[layer])
	[[it getItem] draw:dest];
}


void update_candy(void)
{
    ListIterator *it, *nx;
    enum CANDY_LAYER l;

    foreach_layer (l) {
	foreach_nx (it, nx, candy_list[l]) {
	    Candy *candy = [it getItem];
	    nx = [it next];

	    if ([candy update] == THING_DEAD) {
                [candy_list[l] removeItem:candy];
                [candy free];	/* Free candy!! */
            }
	}
    }
}


Candy *spawn_candy(Class class, int x, int y, enum CANDY_LAYER layer)
{
    Candy *candy;
    ASSERT_LAYER(layer);

    candy = [class new];
    if (not candy)
	return nil;

    [candy setX:x Y:y];
    [candy_list[layer] insertItem:candy];
    return candy;
}

/*-----------------------------------------------------------*/

void candy_init(void)
{
    enum CANDY_LAYER l;

    foreach_layer (l) {
        candy_list[l] = [LIST_NEW];
	assert(candy_list[l]);
    }
}


void candy_shutdown(void)
{
    enum CANDY_LAYER l;

    foreach_layer (l) {
        if (candy_list[l])
            candy_list[l] = [candy_list[l] free];
    }
}
