; install.nsi
;
; Put the main program inside ./dist/
;

;------------------------------------------------------------
; The name of the project, setup filename and default installation directory.

Name "Raid'em"
OutFile "raidem-0.3.1-setup.exe"
InstallDir $PROGRAMFILES\Raidem

;------------------------------------------------------------
; Pages

Page directory
Page instfiles

UninstallText "This will uninstall Raid'em.  All zips inside raidem/data/ will be deleted.  If you want to keep anything (like this wonderful game), abort now.  Otherwise, click Uninstall."
UninstPage uninstConfirm
UninstPage instfiles

;------------------------------------------------------------
; Installer

Section "Installer"
  ; This is shit.
  MessageBox MB_YESNO "Install for all users?" IDYES inst_all IDNO skip
  inst_all:
  SetShellVarContext all
  skip:

  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  
  ; The game, and an uninstaller.
  File /r dist\*.*
  CreateDirectory  "$INSTDIR\music"
  CreateDirectory  "$INSTDIR\music\level1"
  CreateDirectory  "$INSTDIR\music\level2"
  CreateDirectory  "$INSTDIR\music\level3"
  CreateDirectory  "$INSTDIR\music\menu"
  WriteUninstaller "$INSTDIR\uninstall.exe"

  ; Shortcuts
  CreateDirectory "$SMPROGRAMS\Raid'em"
  CreateShortCut "$SMPROGRAMS\Raid'em\Raid'em.lnk" "$INSTDIR\raidem.exe"
  CreateShortCut "$SMPROGRAMS\Raid'em\Raid'em (windowed).lnk" "$INSTDIR\raidem.exe" "--windowed"
  CreateShortCut "$SMPROGRAMS\Raid'em\REdit.lnk" "$INSTDIR\raidem.exe" "--edit --width 800 --height 600"
  CreateShortCut "$SMPROGRAMS\Raid'em\Readme.lnk" "$INSTDIR\README.txt"
  CreateShortCut "$SMPROGRAMS\Raid'em\Uninstall Raid'em.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\Raid'em\Explore Raid'em directory.lnk" "$INSTDIR"
SectionEnd

;------------------------------------------------------------
; Uninstaller

Section "Uninstall"
  ; Dodgy way to check if installed for single/all users.
  IfFileExists "$SMPROGRAMS\Raid'em\*.lnk" skip
  SetShellVarContext all
  skip:

  ; Start Menu items.
  Delete "$SMPROGRAMS\Raid'em\*.lnk"
  RMDir "$SMPROGRAMS\Raid'em"

  ; Better way to do this?
  ; Delete stuff.
  ;; Data
  Delete "$INSTDIR\data\*.zip"
  RMDir  "$INSTDIR\data"

  ;; Demos
  Delete "$INSTDIR\demos\demo1.rec"
  Delete "$INSTDIR\demos\demo2.rec"
  Delete "$INSTDIR\demos\demo3.rec"
  RMDir  "$INSTDIR\demos"

  ;; Maps
  Delete "$INSTDIR\maps\level1.map"
  Delete "$INSTDIR\maps\level2.map"
  Delete "$INSTDIR\maps\level3.map"
  RMDir  "$INSTDIR\maps"

  ;; Music
  RMDir  "$INSTDIR\music\level1"
  RMDir  "$INSTDIR\music\level2"
  RMDir  "$INSTDIR\music\level3"
  RMDir  "$INSTDIR\music\menu"
  RMDir  "$INSTDIR\music"

  Delete "$INSTDIR\raidem.exe"
  Delete "$INSTDIR\uninstall.exe"
  Delete "$INSTDIR\ChangeLog"
  Delete "$INSTDIR\ChangeLog-0.1"
  Delete "$INSTDIR\ChangeLog-0.2"
  Delete "$INSTDIR\ChangeLog-0.3"
  Delete "$INSTDIR\game.cfg"
  Delete "$INSTDIR\joystick.cfg"
  Delete "$INSTDIR\keyboard.cfg"
  Delete "$INSTDIR\INSTALLING.txt"
  Delete "$INSTDIR\LICENCE.txt"
  Delete "$INSTDIR\README.txt"
  Delete "$INSTDIR\damages.txt"
  Delete "$INSTDIR\scores.txt"
  Delete "$INSTDIR\alleg42.dll"
  Delete "$INSTDIR\libpng12.dll"
  Delete "$INSTDIR\pthreadGC1.dll"
  Delete "$INSTDIR\zlib1.dll"
  RMDir  "$INSTDIR"
SectionEnd

Function un.onGUIEnd
  ; If instdir still exists, open it.
  IfFileExists "$INSTDIR\*.*" +1 skip
  ExecShell "open" "$INSTDIR"
  skip:
FunctionEnd
