/* This file is part of the alrand library.
   alrand is Copyright by Vincent Penquerc'h <lyrian -at- kezako -dot- net>.

   The alrand library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The alrand library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the alrand Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA. */

#ifndef _ALRAND_MERSENNE_TWISTER_H_
#define _ALRAND_MERSENNE_TWISTER_H_

#include "alrand.h"

#ifdef __cplusplus
extern "C" {
#endif

alrand_state *alrand_mersenne_twister_create(alrand_uint32_t seed);
void alrand_mersenne_twister_seed(alrand_state *state,alrand_uint32_t seed);
void alrand_mersenne_twister_seed_v(alrand_state *state,alrand_uint32_t *seed);
alrand_uint32_t alrand_mersenne_twister_generate(alrand_state *state);
void alrand_mersenne_twister_destroy(alrand_state *state);

int alrand_mersenne_twister_save(
  alrand_state *state,void (*write)(alrand_uint32_t,void*),void*
);
alrand_state *alrand_mersenne_twister_load(
  alrand_uint32_t (*read)(void*),void*
);

#ifdef __cplusplus
}
#endif

#endif

