/* This file is part of the alrand library.
   alrand is Copyright by Vincent Penquerc'h <lyrian -at- kezako -dot- net>.

   The alrand library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The alrand library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the alrand Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA. */

#ifndef _ALRAND_LOAD_SAVE_BZLIB_H_
#define _ALRAND_LOAD_SAVE_BZLIB_H_

#include <bzlib.h>
#include "alrand.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Platform dependent - do not load and save on different architectures */

static inline void alrandint_write_to_bzfile(alrand_uint32_t data,BZFILE *file)
{
  int error;
  bzWrite(&error,file,&data,sizeof(data));
}

static inline alrand_uint32_t alrandint_read_from_bzfile(BZFILE *file)
{
  alrand_uint32_t data;
  int error;
  bzRead(&error,file,&data,sizeof(data));
  return data;
}

int alrand_save_to_bzfile(alrand_state *state,BZFILE *file)
{
  return alrand_save(state,&alrandint_write_to_bzfile,file);
}

alrand_state *alrand_load_from_bzfile(BZFILE *file)
{
  return alrand_load(&alrandint_read_from_bzfile,file);
}

#ifdef __cplusplus
}
#endif

#endif
