/* This file is part of the alrand library.
   alrand is Copyright by Vincent Penquerc'h <lyrian -at- kezako -dot- net>.

   The alrand library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The alrand library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the alrand Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA. */

#ifndef _ALRAND_H_
#define _ALRAND_H_

#include <unistd.h>
#include "config.h"

#define ALRAND_MAJOR 1
#define ALRAND_MINOR 0
#define ALRAND_PATCH 1
#define ALRAND_MAKE_VERSION(x,y,z) (((x)*10000)+((y)*100)+(z))
#define ALRAND_VERSION ALRAND_MAKE_VERSION(ALRAND_MAJOR,ALRAND_MINOR,ALRAND_PATCH)
#define ALRAND_ID "alrand 1.0.1"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
  alrand_type_mersenne_twister,
  alrand_type_linear_congruential,
  alrand_num_types
} alrand_generator_type;

struct alrand_state;

typedef struct {
  void (*seed)(struct alrand_state*,alrand_uint32_t);
  alrand_uint32_t (*generate)(struct alrand_state*);
  void (*destroy)(struct alrand_state*);
  int (*save)(struct alrand_state*,void (*)(alrand_uint32_t,void*),void*);
} alrand_vtable;


typedef struct alrand_state {
  alrand_generator_type type;
  alrand_vtable *vtable;
  struct {
  } priv;
} alrand_state;

void alrand_init();
void alrand_exit();

/* Generic interface */
alrand_state *alrand_create(alrand_generator_type type,alrand_uint32_t seed);
void alrand_destroy(alrand_state *state);
void alrand_seed(alrand_state *state,alrand_uint32_t seed);
alrand_uint32_t alrand_generate(alrand_state *state);

/* Global interface */
void alrand_srand(alrand_uint32_t);
alrand_uint32_t alrand_rand();
void alrand_set_global_generator_type(alrand_generator_type type);
alrand_generator_type alrand_get_global_generator_type();

/* State persistence */
int alrand_save(alrand_state *state,void (*write)(alrand_uint32_t,void*),void*);
alrand_state *alrand_load(alrand_uint32_t (*read)(void*),void*);

#ifdef __cplusplus
}
#endif

#endif
