/* This file is part of the alrand library.
   alrand is Copyright by Vincent Penquerc'h <lyrian -at- kezako -dot- net>.

   The alrand library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The alrand library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the alrand Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA. */

#include <stdio.h>
#include <stdlib.h>

static void write(char *type)
{
  FILE *f=fopen("config.h","wt");
  if (!f) exit(1);
  fprintf(f,"typedef %s alrand_uint32_t;\n",type);
  fclose(f);
  exit(0);
}

#define TEST(type)                    \
  do {                                \
    if (sizeof(type)==4) write(#type);\
  } while (0)

int main()
{
  /* I'd use uint32_t, but it'd get messy if <stdint.h> isn't here
     and I've not gotten around learning autoconf and friends yet */
  TEST(unsigned long);
  TEST(unsigned short);
  TEST(unsigned int);
  fprintf(stderr,"Unable to determine 32 bit unsigned type\n");
  return 1;
}
