@echo off

rem Sets up the Adime package for building with the specified compiler,
rem and if possible converting text files from LF to CR/LF format.


rem check that number of args is ok
if [%3] == []        goto arg2
goto help


rem check if second arg is ok
:arg2
if [%2] == [--quick] goto arg1
if [%2] == []        goto arg1
goto help


rem check if first arg is ok
:arg1
if [%1] == [bcc32]   goto begin
if [%1] == [djgpp]   goto begin
if [%1] == [mingw32] goto begin
if [%1] == [msvc]    goto begin
if [%1] == [watcom]  goto begin
goto help


rem echo header to makefile, then goto platform specific section
:begin
echo # generated by fix.bat > makefile
if [%1] == [bcc32]   goto bcc32
if [%1] == [djgpp]   goto djgpp
if [%1] == [mingw32] goto mingw32
if [%1] == [msvc]    goto msvc
if [%1] == [watcom]  goto watcom
echo internal error: not reached
goto end


:bcc32
echo Configuring Adime for Windows/BCC32...
echo MAKEFILE_INC = makefile.bcc >> makefile
goto finish


:djgpp
echo Configuring Adime for DOS/djgpp...
echo MAKEFILE_INC = makefile.dj >> makefile
goto finish


:mingw32
echo Configuring Adime for Windows/Mingw32...
echo MAKEFILE_INC = makefile.mgw >> makefile
goto finish


:msvc
echo Configuring Adime for Windows/MSVC...
echo MAKEFILE_INC = makefile.vc >> makefile
goto finish


:watcom
echo Configuring Adime for DOS/Watcom...
echo MAKEFILE_INC = makefile.wat >> makefile
goto finish


:help
echo.
echo Usage: fix platform [--quick]
echo.
echo Where platform is one of:
echo mingw32
echo msvc
echo bcc32
echo djgpp
echo watcom
echo The --quick parameter turns off LF to CR/LF conversion.
echo The --quick parameter is used to turn off LF to CR/LF conversion.
echo.
goto end


rem write end of makefile and possibly convert end of line format
:finish
echo include misc/makefile.all >> makefile

if [%2] == [--quick] goto done
if [%1] == [bcc32]   goto done
if [%1] == [mingw32] goto done

echo Converting Adime files to DOS CR/LF format...
utod *.bat .../*.c .../*.h
utod .../*.txt .../*._tx makefile* misc/makefile.* readme.*


:done
echo Done!


:end
