/* -*- ObjC -*- */
#ifndef __included_weapon_h
#define __included_weapon_h

#include <objc/Object.h>

@protocol PulseWeapon
- setWaveDelay:(int)t;
- setShotDelay:(int)t1 WaveDelay:(int)t2;
- setShotsPerWave:(int)n;
- (int) currentShot;
@end

/*------------------------------------------------------------*/

@interface Weapon: Object
{
    Class projectile;
    int fire_tics;		/* Tics until next shot. */
    int shot_delay;		/* Tics between shots. */
    BOOL difficulty_modifier;
}
+ newWithProjectile:(Class)c;
- setDifficultyModifier:(BOOL)yesno;
- setProjectile:(Class)c;
- setShotDelay:(int)t;
- setFireTics:(int)t;
- (int) fireTics;
- (BOOL) fireFromX:(double)x Y:(double)y;
- (BOOL) fireFromX:(double)x Y:(double)y Angle:(double)theta;
@end

@interface PulseWeapon: Weapon <PulseWeapon>
{
    int wave_delay;
    int shots_per_wave, current_shot_num;
}
@end

/*------------------------------------------------------------*/

@interface OffcentreWeapon: Weapon
{
    int xd, yd;			/* x/y displacement. */
}
- setXDisplacement:(double)x YDisplacement:(double)y;
@end

@interface OffcentrePulseWeapon: OffcentreWeapon <PulseWeapon>
{
    int wave_delay;
    int shots_per_wave, current_shot_num;
}
@end

@interface OffcentrePausePulseWeapon: OffcentrePulseWeapon
@end

/*------------------------------------------------------------*/

@interface DualWeapon: OffcentreWeapon <PulseWeapon>
{
    int wave_delay;
    int shots_per_wave, current_shot_num;
}
@end

/*--------------------------------------------------------------*/

@interface SideWeapon: OffcentreWeapon
@end

/*------------------------------------------------------------*/

@interface RingWeapon: Weapon
{
    double step_size;
    int num_steps;
}
- setStepSize:(double)ss;
- setNumSteps:(int)steps;
@end

/*--------------------------------------------------------------*/

@interface SprayWeapon: Weapon
{
    int shots_per_wave;
    double spray;
}
- setShotsPerWave:(int)n;
- setSpray:(double)theta;
@end

#endif
