/* -*- ObjC -*- */
#ifndef __included_waypoint_h
#define __included_waypoint_h

#include <objc/Object.h>
#include "waypoint.inc"

#define FREE_SPLINE(w)		if (w) { free_spline(w); w = NULL; }

enum PATH_FOLLOW_STATE {
    PATH_NORMAL,
    PATH_REACHED_WAYPOINT,
    PATH_ENDED,
};

@class List;

@interface ControlPoint: Object
{
    double x, y;
    unsigned int steps;	   /* Number of steps to reach destination. */

    /* These are points that help control the spline between two
       points, but the spline does not cross it.  Their positions are
       relative to the control point. */
    struct {
	double x, y;
    } control_point[2];
}
- (id) setControlPoint:(unsigned int)n X:(double)x_ Y:(double)y_;
- (id) setSteps:(unsigned int)steps_;
- (id) setX:(double)x_ Y:(double)y_;
- (id) setX:(double)x_ Y:(double)y_ steps:(unsigned int)steps_;

- (void) getControlPoint:(unsigned int)n X:(double *)x_ Y:(double *)y_;
- (unsigned int) steps;
- (void) getX:(double *)x_ Y:(double *)y_;
@end


unsigned int spline_length(List *list);

waypoint_t *reticulate_spline(waypoint_t waypoints[], List *cp_list);
waypoint_t *articulate_spline(List *cp_list);

unsigned int load_spline(const char *fn, waypoint_t *waypoints[], List **ll);
unsigned int load_spline_from_memory(const void *buffer, int size, waypoint_t *waypoints[], List **ll);

void free_spline(waypoint_t waypoints[]);

#if 0
void waypoint_init(void);
void waypoint_shutdown(void);
#endif

#endif
