/* -*- ObjC -*- */
#ifndef __included_miniboss0_h
#define __included_miniboss0_h

#include "candy/turret.h"
#include "unit.h"
#include "weapon.h"

#define MINIBOSS0_GUN_TURRET		0
#define MINIBOSS0_LASER_TURRET		1
#define MINIBOSS0_RAILGUN_TURRET	2
#define MINIBOSS0_NUM_CHILDREN		3

@protocol MiniBoss0Child
- (id) setParent:(Unit<OwnsChildren> *)unit;
- (int) health;
@end

@protocol MiniBoss0Debris
- (void) die;
@end

/*------------------------------------------------------------*/

@interface MiniBoss0: Unit <Boss, OwnsChildren>
{
    double travel_range;
    double last_track_y;
    Unit<MiniBoss0Child> *child[MINIBOSS0_NUM_CHILDREN];
    Candy<MiniBoss0Debris> *debris[MINIBOSS0_NUM_CHILDREN];

    RingWeapon *ring_gun;	/* Used after the Railgun is destroyed. */
}
- (double) velocity;
@end

/*------------------------------------------------------------*/

@interface MiniBoss0AbstractChild: Unit <MiniBoss0Child>
{
    int child_num;
    MiniBoss0 *parent;
    double desired_angle, max_rotation_angle;
}
- (void) findDesiredAngle;
@end

@interface MiniBoss0AbstractOverlay: Candy <MiniBoss0Debris>
{
    int child_num;
}
@end

#endif
