/* -*- ObjC -*- */
#ifndef __included_khan_h
#define __included_khan_h

#include "candy.h"
#include "unit.h"

enum KHAN_UNIT_ID {
    KHAN_CANNON,
    KHAN_TURRET,
    KHAN_VULCAN_L,
    KHAN_VULCAN_R,
    KHAN_NUM_CHILDREN
};

enum KHAN_PHASE {
    KHAN_STOP_AT_CANNON,
    KHAN_FIRE_CANNON,
    KHAN_RELEASE,		/* Blow up legs. */
    KHAN_RETREAT,
    KHAN_FIRE_TURRET
};

@interface Khan: Unit <Boss>
{
    Unit *child[KHAN_NUM_CHILDREN];
    Candy *legs;
    enum KHAN_PHASE boss_phase;

    int vulcan_activation_tics;

    /* Time for Khan to pack up and begin retreating. */
    int retreat_tics;

    /* Recoil due to cannon blowing up. */
    double yv;

    int die_time;
}
- (void) disownChild:(Unit *)ch;
@end

#endif
